/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import io.crate.action.FutureActionListener;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private static final Logger LOGGER = LogManager.getLogger(RemoteRecoveryTargetHandler.class);
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final Map<Object, RetryableAction<?>> onGoingRetryableActions = new ConcurrentHashMap();
    private final TransportRequestOptions translogOpsRequestOptions;
    private final TransportRequestOptions fileChunkRequestOptions;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final AtomicLong requestSeqNoGenerator = new AtomicLong(0L);
    private final Consumer<Long> onSourceThrottle;
    private final boolean retriesSupported;
    private volatile boolean isCancelled = false;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle) {
        this.transportService = transportService;
        this.threadPool = transportService.getThreadPool();
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.onSourceThrottle = onSourceThrottle;
        this.translogOpsRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionLongTimeout()).build();
        this.fileChunkRequestOptions = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.RECOVERY).withTimeout(recoverySettings.internalActionTimeout()).build();
        this.retriesSupported = targetNode.getVersion().onOrAfter(Version.V_5_1_0);
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/prepare_translog";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryPrepareForTranslogOperationsRequest request = new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, totalTranslogOps);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = listener.map(r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/prepare_translog", request, options, responseListener, reader);
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/finalize";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFinalizeRecoveryRequest request = new RecoveryFinalizeRecoveryRequest(this.recoveryId, requestSeqNo, this.shardId, globalCheckpoint, trimAboveSeqNo);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionLongTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = listener.map(r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/finalize", request, options, responseListener, reader);
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        FutureActionListener future = new FutureActionListener();
        ActionListenerResponseHandler<TransportResponse.Empty> handler = new ActionListenerResponseHandler<TransportResponse.Empty>(future, in -> TransportResponse.Empty.INSTANCE, "same");
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", (TransportRequest)new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build(), handler);
        try {
            future.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", ex);
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof ElasticsearchException) {
                ElasticsearchException esEx = (ElasticsearchException)throwable;
                throw esEx;
            }
            throw new TransportException("Failed execution", ex);
        }
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        String action = "internal:index/shard/recovery/translog_ops";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary);
        Writeable.Reader<RecoveryTranslogOperationsResponse> reader = RecoveryTranslogOperationsResponse::new;
        ActionListener responseListener = listener.map(r -> r.localCheckpoint);
        this.executeRetryableAction("internal:index/shard/recovery/translog_ops", request, this.translogOpsRequestOptions, responseListener, reader);
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/filesInfo";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFilesInfoRequest request = new RecoveryFilesInfoRequest(this.recoveryId, requestSeqNo, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = listener.map(r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/filesInfo", request, options, responseListener, reader);
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/clean_files";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryCleanFilesRequest request = new RecoveryCleanFilesRequest(this.recoveryId, requestSeqNo, this.shardId, sourceMetadata, totalTranslogOps, globalCheckpoint);
        TransportRequestOptions options = TransportRequestOptions.builder().withTimeout(this.recoverySettings.internalActionTimeout()).build();
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = listener.map(r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/clean_files", request, options, responseListener, reader);
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.recoverySettings.rateLimiter();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        String action = "internal:index/shard/recovery/file_chunk";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFileChunkRequest request = new RecoveryFileChunkRequest(this.recoveryId, requestSeqNo, this.shardId, fileMetadata, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.executeRetryableAction("internal:index/shard/recovery/file_chunk", request, this.fileChunkRequestOptions, listener.map(r -> null), reader);
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        if (this.onGoingRetryableActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("recovery was cancelled");
        this.threadPool.generic().execute(() -> {
            for (RetryableAction<?> action : this.onGoingRetryableActions.values()) {
                action.cancel(exception);
            }
            this.onGoingRetryableActions.clear();
        });
    }

    private <T extends TransportResponse> void executeRetryableAction(final String action, final RecoveryTransportRequest request, final TransportRequestOptions options, ActionListener<T> actionListener, final Writeable.Reader<T> reader) {
        Object key = new Object();
        ActionListener<T> removeListener = ActionListener.runBefore(actionListener, () -> this.onGoingRetryableActions.remove(key));
        TimeValue initialDelay = TimeValue.timeValueMillis((long)200L);
        TimeValue timeout = this.recoverySettings.internalActionRetryTimeout();
        RetryableAction retryableAction = new RetryableAction<T>(this, LOGGER, this.threadPool, initialDelay, timeout, removeListener){
            final /* synthetic */ RemoteRecoveryTargetHandler this$0;
            {
                this.this$0 = this$0;
                super(logger, threadPool, initialDelay, timeoutValue, listener);
            }

            @Override
            public void tryAction(ActionListener<T> listener) {
                this.this$0.transportService.sendRequest(this.this$0.targetNode, action, (TransportRequest)request, options, new ActionListenerResponseHandler(listener, reader, "generic"));
            }

            @Override
            public boolean shouldRetry(Exception e) {
                return this.this$0.retriesSupported && RemoteRecoveryTargetHandler.retryableException(e);
            }
        };
        this.onGoingRetryableActions.put(key, retryableAction);
        retryableAction.run();
        if (this.isCancelled) {
            retryableAction.cancel(new CancellableThreads.ExecutionCancelledException("recovery was cancelled"));
        }
    }

    private static boolean retryableException(Exception e) {
        if (e instanceof ConnectTransportException) {
            return true;
        }
        if (e instanceof SendRequestTransportException) {
            Throwable cause = SQLExceptions.unwrap(e);
            return cause instanceof ConnectTransportException;
        }
        if (e instanceof RemoteTransportException) {
            Throwable cause = SQLExceptions.unwrap(e);
            return cause instanceof CircuitBreakingException || cause instanceof EsRejectedExecutionException;
        }
        return false;
    }
}

