/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import io.crate.common.unit.TimeValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;

public final class ProcessService {
    private static final Logger LOGGER = LogManager.getLogger(ProcessService.class);
    private final ProcessProbe probe = ProcessProbe.getInstance();
    private final SingleObjectCache<ProcessStats> processStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.process.refresh_interval", TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);

    public ProcessService(Settings settings) {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.processStatsCache = new ProcessStatsCache(refreshInterval, this.probe.processStats());
        LOGGER.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    public ProcessStats stats() {
        return this.processStatsCache.getOrRefresh();
    }

    private class ProcessStatsCache
    extends SingleObjectCache<ProcessStats> {
        ProcessStatsCache(TimeValue interval, ProcessStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected ProcessStats refresh() {
            return ProcessService.this.probe.processStats();
        }
    }
}

