/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ExecutorBuilder {
    private final String name;

    public ExecutorBuilder(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    protected static String settingsKey(String prefix, String key) {
        return String.join((CharSequence)".", prefix, key);
    }

    protected int applyHardSizeLimit(Settings settings, String name) {
        if (name.equals("write")) {
            return 1 + EsExecutors.numberOfProcessors(settings);
        }
        return Integer.MAX_VALUE;
    }

    public abstract List<Setting<?>> getRegisteredSettings();

    abstract ThreadPool.ExecutorHolder build(Settings var1);

    abstract String formatInfo(ThreadPool.Info var1);
}

