/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.StreamOutput;

final class CompressibleBytesOutputStream
extends StreamOutput {
    private final OutputStream stream;
    private final BytesStream bytesStreamOutput;
    private final boolean shouldCompress;

    CompressibleBytesOutputStream(BytesStream bytesStreamOutput, boolean shouldCompress) throws IOException {
        this.bytesStreamOutput = bytesStreamOutput;
        this.shouldCompress = shouldCompress;
        this.stream = shouldCompress ? CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.flushOnCloseStream(bytesStreamOutput)) : bytesStreamOutput;
    }

    BytesReference materializeBytes() throws IOException {
        if (this.shouldCompress) {
            this.stream.close();
        }
        return this.bytesStreamOutput.bytes();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.stream.write(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.stream != this.bytesStreamOutput) {
            assert (this.shouldCompress) : "If the streams are different we should be compressing";
            IOUtils.close((Closeable[])new Closeable[]{this.stream});
        }
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

