/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class RemoteConnectionParser {
    public static InetSocketAddress parseConfiguredAddress(String configuredAddress) {
        InetAddress hostAddress;
        String host = RemoteConnectionParser.parseHost(configuredAddress);
        int port = RemoteConnectionParser.parsePort(configuredAddress);
        try {
            hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("unknown host [" + host + "]", e);
        }
        return new InetSocketAddress(hostAddress, port);
    }

    static String parseHost(String configuredAddress) {
        return configuredAddress.substring(0, RemoteConnectionParser.indexOfPortSeparator(configuredAddress));
    }

    public static int parsePort(String remoteHost) {
        try {
            int port = Integer.parseInt(remoteHost.substring(RemoteConnectionParser.indexOfPortSeparator(remoteHost) + 1));
            if (port <= 0) {
                throw new IllegalArgumentException("port number must be > 0 but was: [" + port + "]");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse port", e);
        }
    }

    private static int indexOfPortSeparator(String remoteHost) {
        int portSeparator = remoteHost.lastIndexOf(58);
        if (portSeparator == -1 || portSeparator == remoteHost.length()) {
            throw new IllegalArgumentException("remote hosts need to be configured as [host:port], found [" + remoteHost + "] instead");
        }
        return portSeparator;
    }
}

