/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.unit.TimeValue;
import io.crate.types.DataTypes;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;

public final class TransportSettings {
    public static final String DEFAULT_PROFILE = "default";
    public static final String FEATURE_PREFIX = "transport.features";
    public static final Setting<List<String>> HOST = Setting.listSetting("transport.host", Collections.emptyList(), Function.identity(), DataTypes.STRING_ARRAY, Setting.Property.NodeScope);
    public static final Setting<List<String>> PUBLISH_HOST = Setting.listSetting("transport.publish_host", HOST, Function.identity(), DataTypes.STRING_ARRAY, Setting.Property.NodeScope);
    public static final Setting<List<String>> BIND_HOST = Setting.listSetting("transport.bind_host", HOST, Function.identity(), DataTypes.STRING_ARRAY, Setting.Property.NodeScope);
    public static final Setting<String> OLD_PORT = new Setting("transport.tcp.port", "4300-4400", Function.identity(), DataTypes.STRING, Setting.Property.NodeScope);
    public static final Setting<String> PORT = new Setting<String>("transport.port", OLD_PORT, Function.identity(), DataTypes.STRING, Setting.Property.NodeScope);
    public static final Setting<Integer> PUBLISH_PORT = Setting.intSetting("transport.publish_port", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Boolean> OLD_TRANSPORT_COMPRESS = Setting.boolSetting("transport.tcp.compress", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> TRANSPORT_COMPRESS = Setting.boolSetting("transport.compress", OLD_TRANSPORT_COMPRESS, Setting.Property.NodeScope);
    public static final Setting<TimeValue> PING_SCHEDULE = Setting.timeSetting("transport.ping_schedule", TimeValue.timeValueSeconds((long)-1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> TCP_CONNECT_TIMEOUT = Setting.timeSetting("transport.tcp.connect_timeout", NetworkService.TCP_CONNECT_TIMEOUT, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CONNECT_TIMEOUT = Setting.timeSetting("transport.connect_timeout", TCP_CONNECT_TIMEOUT, Setting.Property.NodeScope);
    public static final Setting<Settings> DEFAULT_FEATURES_SETTING = Setting.groupSetting("transport.features.", Setting.Property.NodeScope);
    public static final Setting<Boolean> OLD_TCP_NO_DELAY = Setting.boolSetting("transport.tcp_no_delay", NetworkService.TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_NO_DELAY = Setting.boolSetting("transport.tcp.no_delay", OLD_TCP_NO_DELAY, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_KEEP_ALIVE = Setting.boolSetting("transport.tcp.keep_alive", NetworkService.TCP_KEEP_ALIVE, Setting.Property.NodeScope);
    public static final Setting<Boolean> TCP_REUSE_ADDRESS = Setting.boolSetting("transport.tcp.reuse_address", NetworkService.TCP_REUSE_ADDRESS, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TCP_SEND_BUFFER_SIZE = Setting.byteSizeSetting("transport.tcp.send_buffer_size", NetworkService.TCP_SEND_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> TCP_RECEIVE_BUFFER_SIZE = Setting.byteSizeSetting("transport.tcp.receive_buffer_size", NetworkService.TCP_RECEIVE_BUFFER_SIZE, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_RECOVERY = Setting.intSetting("transport.connections_per_node.recovery", 2, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_BULK = Setting.intSetting("transport.connections_per_node.bulk", 3, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_REG = Setting.intSetting("transport.connections_per_node.reg", 6, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_STATE = Setting.intSetting("transport.connections_per_node.state", 1, 1, Setting.Property.NodeScope);
    public static final Setting<Integer> CONNECTIONS_PER_NODE_PING = Setting.intSetting("transport.connections_per_node.ping", 1, 1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> SLOW_OPERATION_THRESHOLD_SETTING = Setting.positiveTimeSetting("transport.slow_operation_logging_threshold", TimeValue.timeValueSeconds((long)5L), Setting.Property.Dynamic, Setting.Property.NodeScope);

    private TransportSettings() {
    }
}

