/*
 * Decompiled with CFR 0.152.
 */
package io.crate.gcs;

import com.google.auth.oauth2.ServiceAccountCredentials;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.InvalidArgumentException;
import java.net.URI;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public record GCSClientSettings(ServiceAccountCredentials credentials, String endpoint, String projectId, TimeValue connectTimeout, TimeValue readTimeout, URI tokenUri) {
    static final Setting<SecureString> PRIVATE_KEY_ID_SETTING = Setting.maskedString((String)"private_key_id");
    static final Setting<SecureString> PRIVATE_KEY_SETTING = Setting.maskedString((String)"private_key");
    static final Setting<SecureString> CLIENT_EMAIL_SETTING = Setting.maskedString((String)"client_email");
    static final Setting<SecureString> CLIENT_ID_SETTING = Setting.maskedString((String)"client_id");
    static final Setting<String> ENDPOINT_SETTING = Setting.simpleString((String)"endpoint", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> PROJECT_ID_SETTING = Setting.simpleString((String)"project_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> TOKEN_URI_SETTING = Setting.simpleString((String)"token_uri", (String)"https://oauth2.googleapis.com/token", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> CONNECT_TIMEOUT_SETTING = Setting.timeSetting((String)"connect_timeout", (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting((String)"read_timeout", (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    static GCSClientSettings fromSettings(Settings settings) {
        return new GCSClientSettings(GCSClientSettings.loadCredentials(settings), (String)ENDPOINT_SETTING.get(settings), (String)PROJECT_ID_SETTING.get(settings), (TimeValue)CONNECT_TIMEOUT_SETTING.get(settings), (TimeValue)READ_TIMEOUT_SETTING.get(settings), GCSClientSettings.tokenUri(settings));
    }

    static ServiceAccountCredentials loadCredentials(Settings settings) {
        try {
            return ServiceAccountCredentials.newBuilder().setClientId(((SecureString)CLIENT_ID_SETTING.get(settings)).toString()).setClientEmail(((SecureString)CLIENT_EMAIL_SETTING.get(settings)).toString()).setPrivateKeyId(((SecureString)PRIVATE_KEY_ID_SETTING.get(settings)).toString()).setPrivateKeyString(GCSClientSettings.privateKey(settings)).setTokenServerUri(GCSClientSettings.tokenUri(settings)).setProjectId((String)PROJECT_ID_SETTING.get(settings)).build();
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    private static URI tokenUri(Settings settings) {
        return URI.create((String)TOKEN_URI_SETTING.get(settings));
    }

    private static String privateKey(Settings settings) {
        SecureString secureString = (SecureString)PRIVATE_KEY_SETTING.get(settings);
        return secureString.toString().replaceAll("\\\\n", "\n");
    }
}

