/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;

public final class MathUtils {
    private static final double LN_2 = 0.6931471805599453;
    private static final double TWO_POW_M28 = 3.725290298461914E-9;
    private static final double TWO_POW_P28 = 2.68435456E8;

    private MathUtils() {
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static double asinh(double x) {
        double w;
        if (!Double.isFinite(x)) {
            return x + x;
        }
        double ax = Math.abs(x);
        if (ax < 3.725290298461914E-9) {
            return x;
        }
        if (ax > 2.68435456E8) {
            w = Math.log(ax) + 0.6931471805599453;
        } else if (ax > 2.0) {
            w = Math.log(2.0 * ax + 1.0 / (Math.sqrt(x * x + 1.0) + ax));
        } else {
            double t = x * x;
            w = Math.log1p(ax + t / (1.0 + Math.sqrt(1.0 + t)));
        }
        return Math.copySign(w, x);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static double acosh(double x) {
        if (x < 1.0) {
            return (x - x) / (x - x);
        }
        if (x >= 2.68435456E8) {
            if (!Double.isFinite(x)) {
                return x + x;
            }
            return Math.log(x) + 0.6931471805599453;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x > 2.0) {
            double t = x * x;
            return Math.log(2.0 * x - 1.0 / (x + Math.sqrt(t - 1.0)));
        }
        double t = x - 1.0;
        return Math.log1p(t + Math.sqrt(2.0 * t + t * t));
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static double atanh(double x) {
        double t;
        double ax = Math.abs(x);
        if (ax > 1.0) {
            return (x - x) / (x - x);
        }
        if (ax == 1.0) {
            return x / 0.0;
        }
        if (ax < 3.725290298461914E-9) {
            return x;
        }
        if (ax < 0.5) {
            t = ax + ax;
            t = 0.5 * Math.log1p(t + t * ax / (1.0 - ax));
        } else {
            t = 0.5 * Math.log1p((ax + ax) / (1.0 - ax));
        }
        return Math.copySign(t, x);
    }
}

