/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Paging {
    public static final int NO_PAGING = Integer.MAX_VALUE;
    public static int PAGE_SIZE = 500000;
    public static final long MAX_PAGE_BYTES = (long)((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * 0.1);
    private static final double OVERHEAD_FACTOR = 1.5;

    public static int getWeightedPageSize(@Nullable Integer limit, double weight) {
        return Paging.getWeightedPageSize(limit, weight, 1.5);
    }

    private static int getWeightedPageSize(@Nullable Integer limit, double weight, double overheadFactor) {
        Integer limitOrPageSize = Objects.requireNonNullElse(limit, PAGE_SIZE);
        if (1.0 / weight > (double)limitOrPageSize.intValue()) {
            return limitOrPageSize;
        }
        if (limitOrPageSize <= 150) {
            return limitOrPageSize;
        }
        int dynPageSize = Math.max((int)((double)limitOrPageSize.intValue() * weight * overheadFactor), 1);
        if (limit == null) {
            return dynPageSize;
        }
        return Math.min(dynPageSize, limit);
    }

    public static boolean shouldPage(int maxRowsPerNode) {
        return maxRowsPerNode == -1 || maxRowsPerNode > PAGE_SIZE;
    }
}

