/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import java.util.Objects;

public abstract class Row {
    public static final Row EMPTY = new Row(){
        private final Object[] EMPTY_CELLS = new Object[0];

        @Override
        public int numColumns() {
            return 0;
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException("EMPTY row has no cells");
        }

        @Override
        public Object[] materialize() {
            return this.EMPTY_CELLS;
        }
    };

    public abstract int numColumns();

    public abstract Object get(int var1);

    public Object[] materialize() {
        Object[] result = new Object[this.numColumns()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public final int hashCode() {
        int size;
        int result = size = this.numColumns();
        for (int i = 0; i < size; ++i) {
            Object element = this.get(i);
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row o = (Row)obj;
        int size = this.numColumns();
        if (o.numColumns() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (Objects.equals(this.get(i), o.get(i))) continue;
            return false;
        }
        return true;
    }
}

