/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.ForwardingBatchIterator;

public class SkippingBatchIterator<T>
extends ForwardingBatchIterator<T> {
    private final BatchIterator<T> delegate;
    private final int offset;
    private int skipped = 0;

    public SkippingBatchIterator(BatchIterator<T> delegate, int offset) {
        this.delegate = delegate;
        this.offset = offset;
    }

    @Override
    protected BatchIterator<T> delegate() {
        return this.delegate;
    }

    @Override
    public void moveToStart() {
        super.moveToStart();
        this.skipped = 0;
    }

    @Override
    public boolean moveNext() {
        while (this.skipped < this.offset) {
            if (!this.delegate.moveNext()) {
                return false;
            }
            ++this.skipped;
        }
        return this.delegate.moveNext();
    }
}

