/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.UnsafeArrayRow;
import io.crate.data.breaker.RowAccounting;
import io.crate.data.join.ElementCombiner;
import io.crate.data.join.JoinBatchIterator;
import java.util.ArrayList;
import java.util.function.LongToIntFunction;

public class CrossJoinBlockNLBatchIterator
extends JoinBatchIterator<Row, Row, Row> {
    private final LongToIntFunction blockSizeCalculator;
    private final ArrayList<Object[]> blockBuffer;
    private final UnsafeArrayRow rowWrapper;
    private final RowAccounting<Object[]> rowAccounting;
    private long totalBufferedRowSize = 0L;
    private int blockBufferMaxSize;
    private int bufferPos;
    private boolean rightInitialized;

    public CrossJoinBlockNLBatchIterator(BatchIterator<Row> left, BatchIterator<Row> right, ElementCombiner<Row, Row, Row> combiner, LongToIntFunction blockSizeCalculator, RowAccounting<Object[]> rowAccounting) {
        super(left, right, combiner);
        this.blockSizeCalculator = blockSizeCalculator;
        this.blockBuffer = new ArrayList(0);
        this.rowWrapper = new UnsafeArrayRow();
        this.rowAccounting = rowAccounting;
        this.resizeBlockBuffer();
    }

    private void resizeBlockBuffer() {
        this.rowAccounting.release();
        int avgRowSize = this.blockBuffer.isEmpty() ? -1 : (int)this.totalBufferedRowSize / this.blockBuffer.size();
        this.totalBufferedRowSize = 0L;
        this.blockBufferMaxSize = this.blockSizeCalculator.applyAsInt(avgRowSize);
        this.blockBuffer.clear();
        this.bufferPos = -1;
    }

    @Override
    public void moveToStart() {
        this.left.moveToStart();
        this.right.moveToStart();
        this.activeIt = this.right;
        this.rightInitialized = false;
        this.resizeBlockBuffer();
    }

    @Override
    public boolean moveNext() {
        do {
            if (this.bufferPos == -1) {
                this.activeIt = this.right;
                if (!this.rightInitialized) {
                    if (this.right.moveNext()) {
                        this.rightInitialized = true;
                    } else {
                        return false;
                    }
                }
                this.activeIt = this.left;
                while (this.blockBuffer.size() < this.blockBufferMaxSize) {
                    if (this.left.moveNext()) {
                        Object[] row = ((Row)this.left.currentElement()).materialize();
                        this.totalBufferedRowSize += this.rowAccounting.accountForAndMaybeBreak(row);
                        this.blockBuffer.add(row);
                        continue;
                    }
                    if (this.left.allLoaded()) break;
                    return false;
                }
                this.bufferPos = 0;
            }
            if (this.blockBuffer.isEmpty()) {
                return false;
            }
            this.activeIt = this.right;
            if (this.bufferPos != this.blockBuffer.size()) continue;
            if (this.right.moveNext()) {
                this.bufferPos = 0;
                continue;
            }
            if (this.right.allLoaded()) {
                this.right.moveToStart();
                this.rightInitialized = false;
                this.resizeBlockBuffer();
                continue;
            }
            return false;
        } while (this.bufferPos == -1);
        this.combiner.setRight((Row)this.right.currentElement());
        this.rowWrapper.cells(this.blockBuffer.get(this.bufferPos));
        this.combiner.setLeft(this.rowWrapper);
        ++this.bufferPos;
        return true;
    }

    @Override
    public void close() {
        super.close();
        this.blockBuffer.clear();
    }
}

