/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.classic.ClassicTokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class ClassicTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    ClassicTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.maxTokenLength = settings.getAsInt("max_token_length", Integer.valueOf(255));
    }

    public Tokenizer create() {
        ClassicTokenizer tokenizer = new ClassicTokenizer();
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

