/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class EdgeNGramTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int minGram;
    private final int maxGram;
    public static final int SIDE_FRONT = 1;
    public static final int SIDE_BACK = 2;
    private final int side;

    EdgeNGramTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        this.side = EdgeNGramTokenFilterFactory.parseSide(settings.get("side", "front"));
    }

    static int parseSide(String side) {
        switch (side) {
            case "front": {
                return 1;
            }
            case "back": {
                return 2;
            }
        }
        throw new IllegalArgumentException("invalid side: " + side);
    }

    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        if (this.side == 2) {
            result = new ReverseStringFilter(result);
        }
        result = new EdgeNGramTokenFilter(result, this.minGram, this.maxGram, false);
        if (this.side == 2) {
            result = new ReverseStringFilter(result);
        }
        return result;
    }
}

