/*
 * Decompiled with CFR 0.152.
 */
package io.crate.gcs;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.crate.common.unit.TimeValue;
import io.crate.gcs.GCSClientSettings;
import java.net.URI;
import java.util.HashMap;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;

public class GCSService {
    private volatile HashMap<String, Storage> clientCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage client(RepositoryMetadata metadata) {
        Storage storage = this.clientCache.get(metadata.name());
        if (storage != null) {
            return storage;
        }
        GCSService gCSService = this;
        synchronized (gCSService) {
            Storage existing = this.clientCache.get(metadata.name());
            if (existing != null) {
                return existing;
            }
            Storage newClient = this.createClient(metadata.settings());
            this.clientCache.put(metadata.name(), newClient);
            return newClient;
        }
    }

    synchronized void closeRepositoryClient(String repositoryName) {
        this.clientCache.remove(repositoryName);
    }

    private Storage createClient(Settings settings) {
        GCSClientSettings clientSettings = GCSClientSettings.fromSettings(settings);
        NetHttpTransport httpTransport = new NetHttpTransport.Builder().build();
        HttpTransportOptions httpTransportOptions = new HttpTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(GCSService.toTimeout(clientSettings.connectTimeout()).intValue()).setReadTimeout(GCSService.toTimeout(clientSettings.readTimeout()).intValue()).setHttpTransportFactory(() -> GCSService.lambda$createClient$0((HttpTransport)httpTransport)));
        StorageOptions storageOptions = this.createStorageOptions(clientSettings, httpTransportOptions);
        return (Storage)storageOptions.getService();
    }

    StorageOptions createStorageOptions(GCSClientSettings clientSettings, HttpTransportOptions httpTransportOptions) {
        StorageOptions.Builder storageOptionsBuilder = StorageOptions.newBuilder().setTransportOptions((TransportOptions)httpTransportOptions);
        if (Strings.hasLength((CharSequence)clientSettings.endpoint())) {
            storageOptionsBuilder.setHost(clientSettings.endpoint());
        }
        if (Strings.hasLength((CharSequence)clientSettings.projectId())) {
            storageOptionsBuilder.setProjectId(clientSettings.projectId());
        }
        ServiceAccountCredentials serviceAccountCredentials = clientSettings.credentials();
        URI tokenServerUri = clientSettings.tokenUri();
        if (Strings.hasLength((CharSequence)tokenServerUri.toString())) {
            serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
        }
        storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        return storageOptionsBuilder.build();
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.millis());
    }

    private static /* synthetic */ HttpTransport lambda$createClient$0(HttpTransport httpTransport) {
        return httpTransport;
    }
}

