/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.util.Objects;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

public final class Instrument {
    final AbstractPolyglotImpl.AbstractInstrumentDispatch dispatch;
    final Object receiver;
    final Engine engine;

    Instrument(AbstractPolyglotImpl.AbstractInstrumentDispatch dispatch, Object receiver, Engine engine) {
        this.dispatch = dispatch;
        this.receiver = receiver;
        this.engine = Objects.requireNonNull(engine);
    }

    public String getId() {
        return this.dispatch.getId(this.receiver);
    }

    public String getName() {
        return this.dispatch.getName(this.receiver);
    }

    public OptionDescriptors getOptions() {
        return this.dispatch.getOptions(this.receiver);
    }

    public String getVersion() {
        return this.dispatch.getVersion(this.receiver);
    }

    public <T> T lookup(Class<T> type) {
        return this.dispatch.lookup(this.receiver, type);
    }

    public String getWebsite() {
        return this.dispatch.getWebsite(this.receiver);
    }

    public int hashCode() {
        return this.dispatch.hashCode(this.receiver);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instrument)) {
            return false;
        }
        Object otherImpl = ((Instrument)obj).receiver;
        return this.dispatch.equals(this.receiver, otherImpl);
    }
}

