/*
 * Decompiled with CFR 0.152.
 */
package org.apache.opendal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Properties;

public enum Environment {
    INSTANCE;

    public static final String UNKNOWN = "<unknown>";
    private String classifier = "<unknown>";
    private String projectVersion = "<unknown>";

    public static String getClassifier() {
        return Environment.INSTANCE.classifier;
    }

    public static String getVersion() {
        return Environment.INSTANCE.projectVersion;
    }

    static {
        ClassLoader classLoader = Environment.class.getClassLoader();
        try (InputStream is = classLoader.getResourceAsStream("bindings.properties");){
            Properties properties = new Properties();
            properties.load(is);
            Environment.INSTANCE.projectVersion = properties.getProperty("project.version", UNKNOWN);
        }
        catch (IOException e) {
            throw new UncheckedIOException("cannot load environment properties file", e);
        }
        StringBuilder classifier = new StringBuilder();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            classifier.append("windows");
        } else if (os.startsWith("mac")) {
            classifier.append("osx");
        } else {
            classifier.append("linux");
        }
        classifier.append("-");
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.equals("aarch64")) {
            classifier.append("aarch_64");
        } else {
            classifier.append("x86_64");
        }
        Environment.INSTANCE.classifier = classifier.toString();
    }
}

