/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.azure;

import io.crate.analyze.CopyStatementSettings;
import io.crate.common.collections.Lists;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class AzureBlobStorageSettings {
    private static List<String> SUPPORTED_PROTOCOLS = List.of("https", "http");
    public static final Setting<String> KEY_SETTING = Setting.simpleString((String)"key", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> SAS_TOKEN_SETTING = Setting.simpleString((String)"sas_token", (Setting.Property[])new Setting.Property[0]);
    public static final Setting<String> PROTOCOL_SETTING = new Setting("protocol", "https", s -> {
        if (!SUPPORTED_PROTOCOLS.contains(s)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid protocol `%s`. Expected HTTP or HTTPS", s));
        }
        return s;
    }, (DataType)DataTypes.STRING, new Setting.Property[0]);
    public static final List<Setting<String>> SUPPORTED_SETTINGS = List.of(KEY_SETTING, SAS_TOKEN_SETTING, PROTOCOL_SETTING);

    static void validate(Settings settings, boolean read) {
        List validSettings = Lists.concat(SUPPORTED_SETTINGS.stream().map(Setting::getKey).toList(), (Collection)(read ? CopyStatementSettings.COMMON_COPY_FROM_SETTINGS : CopyStatementSettings.COMMON_COPY_TO_SETTINGS));
        for (String key : settings.keySet()) {
            if (validSettings.contains(key)) continue;
            throw new IllegalArgumentException("Setting '" + key + "' is not supported");
        }
        if (settings.get(SAS_TOKEN_SETTING.getKey()) == null && settings.get(KEY_SETTING.getKey()) == null) {
            throw new IllegalArgumentException("Authentication setting must be provided: either sas_token or key");
        }
    }
}

