/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import io.crate.analyze.repositories.TypeSettings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.azure.AzureRepository;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    public Map<String, Repository.Factory> getRepositories(Environment env, final NamedWriteableRegistry namedWriteableRegistry, final NamedXContentRegistry namedXContentRegistry, final ClusterService clusterService, final RecoverySettings recoverySettings) {
        return Collections.singletonMap("azure", new Repository.Factory(){

            public TypeSettings settings() {
                return new TypeSettings(AzureRepository.mandatorySettings(), AzureRepository.optionalSettings());
            }

            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new AzureRepository(metadata, namedWriteableRegistry, namedXContentRegistry, clusterService, recoverySettings);
            }
        });
    }

    public List<Setting<?>> getSettings() {
        return List.of(AzureRepository.Repository.ACCOUNT_SETTING, AzureRepository.Repository.SAS_TOKEN_SETTING, AzureRepository.Repository.KEY_SETTING);
    }
}

