/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.Row;

public class BiArrayRow
extends Row {
    private Object[] firstCells;
    private Object[] secondCells;

    public BiArrayRow(Object[] firstCells, Object[] secondCells) {
        this.firstCells = firstCells;
        this.secondCells = secondCells;
    }

    @Override
    public int numColumns() {
        return this.firstCells.length + this.secondCells.length;
    }

    @Override
    public Object get(int index) {
        int firstCellsSize = this.firstCells.length;
        if (index >= firstCellsSize) {
            return this.secondCells[index - firstCellsSize];
        }
        return this.firstCells[index];
    }

    @Override
    public Object[] materialize() {
        Object[] copy = new Object[this.numColumns()];
        System.arraycopy(this.firstCells, 0, copy, 0, this.firstCells.length);
        System.arraycopy(this.secondCells, 0, copy, this.firstCells.length, this.secondCells.length);
        return copy;
    }
}

