/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data;

import io.crate.data.BatchIterator;
import io.crate.data.ForwardingBatchIterator;
import java.util.concurrent.CompletionStage;

public final class LimitingBatchIterator<T>
extends ForwardingBatchIterator<T> {
    private final int endPos;
    private final BatchIterator<T> delegate;
    private int pos = -1;

    public static <T> BatchIterator<T> newInstance(BatchIterator<T> delegate, int limit) {
        return new LimitingBatchIterator<T>(delegate, limit);
    }

    private LimitingBatchIterator(BatchIterator<T> delegate, int limit) {
        this.delegate = delegate;
        this.endPos = limit - 1;
    }

    @Override
    protected BatchIterator<T> delegate() {
        return this.delegate;
    }

    @Override
    public void moveToStart() {
        this.pos = -1;
        super.moveToStart();
    }

    @Override
    public boolean moveNext() {
        if (this.pos >= this.endPos) {
            return false;
        }
        if (super.moveNext()) {
            ++this.pos;
            return true;
        }
        return false;
    }

    @Override
    public CompletionStage<?> loadNextBatch() throws Exception {
        if (this.allLoaded()) {
            throw new IllegalStateException("Iterator already fully loaded");
        }
        return super.loadNextBatch();
    }

    @Override
    public boolean allLoaded() {
        return this.pos >= this.endPos || super.allLoaded();
    }
}

