/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.breaker;

import io.crate.data.breaker.RamAccounting;
import java.util.function.LongConsumer;

public final class BlockBasedRamAccounting
implements RamAccounting {
    public static final int MAX_BLOCK_SIZE_IN_BYTES = 0x200000;
    private static final double BREAKER_LIMIT_PERCENTAGE = 0.001;
    private final LongConsumer reserveMemory;
    private final int blockSizeInBytes;
    private long usedBytes = 0L;
    private long reservedBytes = 0L;

    public static int blockSizeInBytesPerShard(long breakerLimit, int shardsUsedOnNode) {
        int blockSize = Math.min((int)((double)breakerLimit * 0.001), 0x200000);
        return blockSize / Math.max(shardsUsedOnNode, 1);
    }

    public static int blockSizeInBytes(long breakerLimit) {
        return Math.min((int)((double)breakerLimit * 0.001), 0x200000);
    }

    public BlockBasedRamAccounting(LongConsumer reserveMemory, int blockSizeInBytes) {
        this.reserveMemory = reserveMemory;
        this.blockSizeInBytes = blockSizeInBytes;
    }

    @Override
    public void addBytes(long bytes) {
        this.usedBytes += bytes;
        if (this.reservedBytes - this.usedBytes < 0L) {
            long reserveBytes = bytes > (long)this.blockSizeInBytes ? bytes : (long)this.blockSizeInBytes;
            try {
                this.reserveMemory.accept(reserveBytes);
            }
            catch (Exception e) {
                this.usedBytes -= bytes;
                throw e;
            }
            this.reservedBytes += reserveBytes;
        }
        assert (this.reservedBytes >= this.usedBytes) : "reservedBytes must be >= usedBytes: " + this.toString();
    }

    @Override
    public long totalBytes() {
        return this.usedBytes;
    }

    @Override
    public void release() {
        this.reserveMemory.accept(-this.reservedBytes);
        this.usedBytes = 0L;
        this.reservedBytes = 0L;
    }

    @Override
    public void close() {
        this.release();
    }

    public String toString() {
        return "RamAccounting{usedBytes=" + this.usedBytes + ", reservedBytes=" + this.reservedBytes + "}";
    }
}

