/*
 * Decompiled with CFR 0.152.
 */
package io.crate.data.join;

import io.crate.data.BatchIterator;
import io.crate.data.join.ElementCombiner;
import io.crate.data.join.JoinBatchIterator;

public class CrossJoinNLBatchIterator<L, R, C>
extends JoinBatchIterator<L, R, C> {
    public CrossJoinNLBatchIterator(BatchIterator<L> left, BatchIterator<R> right, ElementCombiner<L, R, C> combiner) {
        super(left, right, combiner);
    }

    @Override
    public boolean moveNext() {
        if (this.activeIt == this.left) {
            return this.tryAdvanceLeftAndRight();
        }
        return this.tryAdvanceRight();
    }

    private boolean tryAdvanceLeftAndRight() {
        while (this.tryMoveLeft()) {
            this.activeIt = this.right;
            if (this.tryMoveRight()) {
                return true;
            }
            if (!this.right.allLoaded()) {
                return false;
            }
            this.right.moveToStart();
        }
        return false;
    }

    private boolean tryAdvanceRight() {
        if (this.tryMoveRight()) {
            return true;
        }
        if (!this.right.allLoaded()) {
            return false;
        }
        this.right.moveToStart();
        if (this.tryMoveLeft()) {
            return this.tryMoveRight();
        }
        this.activeIt = this.left;
        return false;
    }
}

