/*
 * Decompiled with CFR 0.152.
 */
package io.crate.operation.language;

import io.crate.data.Input;
import io.crate.exceptions.ScriptException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.operation.language.PolyglotLanguage;
import io.crate.operation.language.PolyglotValues;
import io.crate.role.Roles;
import java.io.IOException;
import java.util.List;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;

public final class PolyglotScalar
extends Scalar<Object, Object> {
    private final String script;
    private final String graalLanguageId;

    PolyglotScalar(Signature signature, BoundSignature boundSignature, String graalLanguageId, String script) {
        super(signature, boundSignature);
        this.graalLanguageId = graalLanguageId;
        this.script = script;
    }

    public Scalar<Object, Object> compile(List<Symbol> arguments, String currentUser, Roles roles) {
        try {
            String functionName = this.signature.getName().name();
            return new CompiledFunction(this.graalLanguageId, this.signature, this.boundSignature, PolyglotLanguage.getFunctionValue(this.graalLanguageId, functionName, this.script));
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptException("compile error", e, this.graalLanguageId);
        }
    }

    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        try {
            String functionName = this.signature.getName().name();
            Value function = PolyglotLanguage.getFunctionValue(this.graalLanguageId, functionName, this.script);
            Object[] values = PolyglotValues.toPolyglotValues(args);
            return PolyglotValues.toCrateObject(function.execute(values), this.boundSignature.returnType());
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptException(e.getLocalizedMessage(), e, this.graalLanguageId);
        }
    }

    private static class CompiledFunction
    extends Scalar<Object, Object> {
        private final String language;
        private final Value function;

        private CompiledFunction(String language, Signature signature, BoundSignature boundSignature, Value function) {
            super(signature, boundSignature);
            this.language = language;
            this.function = function;
        }

        @SafeVarargs
        public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
            Object[] values = PolyglotValues.toPolyglotValues(args);
            try {
                return PolyglotValues.toCrateObject(this.function.execute(values), this.boundSignature.returnType());
            }
            catch (PolyglotException e) {
                throw new ScriptException(e.getLocalizedMessage(), (Throwable)e, this.language);
            }
        }
    }
}

