/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTableAddColumn;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.TableElementsAnalyzer;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.AlterTableAddColumn;
import io.crate.sql.tree.Expression;

class AlterTableAddColumnAnalyzer {
    private final Schemas schemas;
    private final NodeContext nodeCtx;

    AlterTableAddColumnAnalyzer(Schemas schemas, NodeContext nodeCtx) {
        this.schemas = schemas;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedAlterTableAddColumn analyze(AlterTableAddColumn<Expression> alterTable, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        if (!alterTable.table().partitionProperties().isEmpty()) {
            throw new UnsupportedOperationException("Adding a column to a single partition is not supported");
        }
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(alterTable.table().getName(), Operation.ALTER, txnCtx.sessionSettings().sessionUser(), txnCtx.sessionSettings().searchPath());
        TableElementsAnalyzer analyzer = new TableElementsAnalyzer(tableInfo, txnCtx, this.nodeCtx, paramTypeHints);
        return analyzer.analyze(alterTable);
    }
}

