/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.metadata.settings.Validators;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.settings.Setting;

public final class CopyStatementSettings {
    public static final Setting<Boolean> WAIT_FOR_COMPLETION_SETTING = Setting.boolSetting("wait_for_completion", true, new Setting.Property[0]);
    public static final Setting<Boolean> OVERWRITE_DUPLICATES_SETTING = Setting.boolSetting("overwrite_duplicates", false, new Setting.Property[0]);
    public static final Setting<Boolean> FAIL_FAST_SETTING = Setting.boolSetting("fail_fast", false, new Setting.Property[0]);
    public static final Setting<Boolean> SHARED_SETTING = Setting.boolSetting("shared", false, new Setting.Property[0]);
    public static final Setting<Integer> NUM_READERS_SETTING = new Setting<Integer>("num_readers", settings -> "1", s -> Setting.parseInt(s, 1, "num_readers"), DataTypes.INTEGER, Setting.Property.Dynamic);
    public static final Setting<String> COMPRESSION_SETTING = Setting.simpleString("compression", Validators.stringValidator("compression", "gzip"), Setting.Property.Dynamic);
    public static final Setting<String> OUTPUT_FORMAT_SETTING = Setting.simpleString("format", Validators.stringValidator("format", "json_object", "json_array"), Setting.Property.Dynamic);
    public static final Setting<String> INPUT_FORMAT_SETTING = new Setting<String>("format", "json", s -> s, Validators.stringValidator("format", "json", "csv"), DataTypes.STRING, Setting.Property.Dynamic);
    public static final Setting<Boolean> EMPTY_STRING_AS_NULL = Setting.boolSetting("empty_string_as_null", false, Setting.Property.Dynamic);
    public static final Setting<Boolean> INPUT_HEADER_SETTINGS = Setting.boolSetting("header", true, Setting.Property.Dynamic);
    public static final Setting<Long> SKIP_NUM_LINES = Setting.longSetting("skip", 0L, 0L, Setting.Property.Dynamic);
    public static final Setting<Character> CSV_COLUMN_SEPARATOR = new Setting<Character>("delimiter", String.valueOf(','), value -> {
        if (value.length() != 1) {
            throw new IllegalArgumentException("Invalid CSV fields delimiter: " + value + ". The delimiter must be a single character.");
        }
        return Character.valueOf(value.charAt(0));
    }, DataTypes.STRING, Setting.Property.Dynamic);
    public static final List<String> COMMON_COPY_TO_SETTINGS = List.of(COMPRESSION_SETTING.getKey(), OUTPUT_FORMAT_SETTING.getKey(), WAIT_FOR_COMPLETION_SETTING.getKey());
    public static final List<String> COMMON_COPY_FROM_SETTINGS = List.of(COMPRESSION_SETTING.getKey(), INPUT_FORMAT_SETTING.getKey(), WAIT_FOR_COMPLETION_SETTING.getKey(), OVERWRITE_DUPLICATES_SETTING.getKey(), FAIL_FAST_SETTING.getKey(), SHARED_SETTING.getKey(), NUM_READERS_SETTING.getKey(), AbstractIndexWriterProjection.BULK_SIZE_SETTING.getKey(), "node_filters", EMPTY_STRING_AS_NULL.getKey(), CSV_COLUMN_SEPARATOR.getKey(), INPUT_HEADER_SETTINGS.getKey(), CSV_COLUMN_SEPARATOR.getKey());

    private CopyStatementSettings() {
    }

    public static <E extends Enum<E>> E settingAsEnum(Class<E> settingsEnum, String settingValue) {
        if (settingValue == null || settingValue.isEmpty()) {
            return null;
        }
        return Enum.valueOf(settingsEnum, settingValue.toUpperCase(Locale.ENGLISH));
    }
}

