/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateAnalyzer;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.common.collections.Tuple;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.AnalyzerElement;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CharFilters;
import io.crate.sql.tree.CreateAnalyzer;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GenericProperty;
import io.crate.sql.tree.NamedProperties;
import io.crate.sql.tree.TokenFilters;
import io.crate.sql.tree.Tokenizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class CreateAnalyzerStatementAnalyzer {
    private final FulltextAnalyzerResolver ftResolver;
    private final NodeContext nodeCtx;

    CreateAnalyzerStatementAnalyzer(FulltextAnalyzerResolver ftResolver, NodeContext nodeCtx) {
        this.ftResolver = ftResolver;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedStatement analyze(CreateAnalyzer<Expression> createAnalyzer, ParamTypeHints paramTypeHints, CoordinatorTxnCtx transactionContext) {
        String extendedAnalyzerName;
        String analyzerIdent = createAnalyzer.ident();
        if (analyzerIdent.equalsIgnoreCase("default")) {
            throw new IllegalArgumentException("Overriding the default analyzer is forbidden");
        }
        if (this.ftResolver.hasBuiltInAnalyzer(analyzerIdent)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot override builtin analyzer '%s'", analyzerIdent));
        }
        if (createAnalyzer.isExtending()) {
            extendedAnalyzerName = createAnalyzer.extendedAnalyzer();
            if (!this.ftResolver.hasAnalyzer(extendedAnalyzerName)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Extended Analyzer '%s' does not exist", extendedAnalyzerName));
            }
        } else {
            extendedAnalyzerName = null;
        }
        Context context = new Context(transactionContext, this.nodeCtx, paramTypeHints);
        for (AnalyzerElement element : createAnalyzer.elements()) {
            AnalyzerElementsAnalysisVisitor.analyze((AnalyzerElement<Expression>)element, context);
        }
        return new AnalyzedCreateAnalyzer(analyzerIdent, extendedAnalyzerName, context.tokenizer, (GenericProperties<Symbol>)new GenericProperties(context.genericAnalyzerProperties), context.tokenFilters, context.charFilters);
    }

    private static class Context {
        @Nullable
        private Tuple<String, GenericProperties<Symbol>> tokenizer;
        private final Map<String, Symbol> genericAnalyzerProperties = new HashMap<String, Symbol>();
        private final Map<String, GenericProperties<Symbol>> charFilters = new HashMap<String, GenericProperties<Symbol>>();
        private final Map<String, GenericProperties<Symbol>> tokenFilters = new HashMap<String, GenericProperties<Symbol>>();
        private final ExpressionAnalyzer exprAnalyzerWithFieldsAsString;
        private final ExpressionAnalysisContext exprContext;

        Context(CoordinatorTxnCtx transactionContext, NodeContext nodeCtx, ParamTypeHints paramTypeHints) {
            this.exprContext = new ExpressionAnalysisContext(transactionContext.sessionSettings());
            this.exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(transactionContext, nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        }
    }

    private static class AnalyzerElementsAnalysisVisitor
    extends DefaultTraversalVisitor<Void, Context> {
        static final AnalyzerElementsAnalysisVisitor INSTANCE = new AnalyzerElementsAnalysisVisitor();

        private AnalyzerElementsAnalysisVisitor() {
        }

        static Void analyze(AnalyzerElement<Expression> node, Context context) {
            node.accept((AstVisitor)INSTANCE, (Object)context);
            return null;
        }

        public Void visitTokenizer(Tokenizer<?> node, Context context) {
            Tokenizer<?> tokenizer = node;
            GenericProperties properties = tokenizer.properties().map(p -> context.exprAnalyzerWithFieldsAsString.convert((Expression)p, context.exprContext));
            context.tokenizer = new Tuple((Object)tokenizer.ident(), (Object)properties);
            return null;
        }

        public Void visitGenericProperty(GenericProperty<?> node, Context context) {
            GenericProperty<?> property = node;
            context.genericAnalyzerProperties.put(property.key(), context.exprAnalyzerWithFieldsAsString.convert((Expression)property.value(), context.exprContext));
            return null;
        }

        public Void visitTokenFilters(TokenFilters<?> node, Context context) {
            TokenFilters<?> tokenFilters = node;
            for (NamedProperties tokenFilter : tokenFilters.tokenFilters()) {
                GenericProperties properties = tokenFilter.properties().map(p -> context.exprAnalyzerWithFieldsAsString.convert((Expression)p, context.exprContext));
                context.tokenFilters.put(tokenFilter.ident(), (GenericProperties<Symbol>)properties);
            }
            return null;
        }

        public Void visitCharFilters(CharFilters<?> node, Context context) {
            CharFilters<?> charFilters = node;
            for (NamedProperties charFilter : charFilters.charFilters()) {
                GenericProperties properties = charFilter.properties().map(p -> context.exprAnalyzerWithFieldsAsString.convert((Expression)p, context.exprContext));
                context.charFilters.put(charFilter.ident(), (GenericProperties<Symbol>)properties);
            }
            return null;
        }
    }
}

