/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateRepository;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.RepositoryAlreadyExistsException;
import io.crate.execution.ddl.RepositoryService;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.CreateRepository;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;

class CreateRepositoryAnalyzer {
    private final RepositoryService repositoryService;
    private final NodeContext nodeCtx;

    CreateRepositoryAnalyzer(RepositoryService repositoryService, NodeContext nodeCtx) {
        this.repositoryService = repositoryService;
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateRepository analyze(CreateRepository<Expression> createRepository, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        String repositoryName = createRepository.repository();
        if (this.repositoryService.getRepository(repositoryName) != null) {
            throw new RepositoryAlreadyExistsException(repositoryName);
        }
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        GenericProperties genericProperties = createRepository.properties().map(p -> exprAnalyzerWithFieldsAsString.convert((Expression)p, exprCtx));
        return new AnalyzedCreateRepository(repositoryName, createRepository.type(), (GenericProperties<Symbol>)genericProperties);
    }
}

