/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedCreateTableAs;
import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.analyze.CreateTableStatementAnalyzer;
import io.crate.analyze.InsertAnalyzer;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateTableAs;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.Node;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public final class CreateTableAsAnalyzer {
    private final CreateTableStatementAnalyzer createTableStatementAnalyzer;
    private final InsertAnalyzer insertAnalyzer;
    private final RelationAnalyzer relationAnalyzer;

    public CreateTableAsAnalyzer(CreateTableStatementAnalyzer createTableStatementAnalyzer, InsertAnalyzer insertAnalyzer, RelationAnalyzer relationAnalyzer) {
        this.createTableStatementAnalyzer = createTableStatementAnalyzer;
        this.insertAnalyzer = insertAnalyzer;
        this.relationAnalyzer = relationAnalyzer;
    }

    public AnalyzedCreateTableAs analyze(CreateTableAs<Expression> createTableAs, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        RelationName relationName = RelationName.of(createTableAs.name().getName(), txnCtx.sessionSettings().searchPath().currentSchema());
        relationName.ensureValidForRelationCreation();
        AnalyzedRelation analyzedSourceQuery = this.relationAnalyzer.analyze((Node)createTableAs.query(), new StatementAnalysisContext(paramTypeHints, Operation.READ, txnCtx));
        List tableElements = Lists.map(analyzedSourceQuery.outputs(), Symbol::toColumnDefinition);
        CreateTable createTable = new CreateTable(createTableAs.name(), tableElements, Optional.empty(), Optional.empty(), GenericProperties.empty(), createTableAs.ifNotExists());
        AnalyzedRelation sourceRelation = this.relationAnalyzer.analyze((Node)createTableAs.query(), new StatementAnalysisContext(paramTypeHints, Operation.READ, txnCtx));
        Supplier<AnalyzedInsertStatement> postponedInsertAnalysis = () -> {
            Insert insert = new Insert(createTableAs.name(), createTableAs.query(), Collections.emptyList(), Collections.emptyList(), Insert.DuplicateKeyContext.none());
            return this.insertAnalyzer.analyze((Insert<Expression>)insert, paramTypeHints, txnCtx);
        };
        return new AnalyzedCreateTableAs(this.createTableStatementAnalyzer.analyze((CreateTable<Expression>)createTable, paramTypeHints, txnCtx), sourceRelation, postponedInsertAnalysis);
    }
}

