/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterTableDropCheckConstraint;
import io.crate.common.collections.Lists;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Locale;

class DropCheckConstraintAnalyzer {
    private final Schemas schemas;

    DropCheckConstraintAnalyzer(Schemas schemas) {
        this.schemas = schemas;
    }

    public AnalyzedAlterTableDropCheckConstraint analyze(Table<?> table, String name, CoordinatorTxnCtx txnCtx) {
        DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(table.getName(), Operation.ALTER, txnCtx.sessionSettings().sessionUser(), txnCtx.sessionSettings().searchPath());
        List<CheckConstraint<Symbol>> checkConstraints = tableInfo.checkConstraints();
        for (CheckConstraint<Symbol> checkConstraint : checkConstraints) {
            if (!name.equals(checkConstraint.name())) continue;
            return new AnalyzedAlterTableDropCheckConstraint(tableInfo, name);
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot find a CHECK CONSTRAINT named [%s], available constraints are: %s", name, Lists.map(checkConstraints, CheckConstraint::name)));
    }
}

