/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.ShardedTable;
import io.crate.sql.tree.Assignment;
import java.util.List;
import java.util.function.Consumer;

public abstract class RerouteAnalyzedStatement
implements DDLStatement {
    private final ShardedTable shardedTable;
    private final List<Assignment<Symbol>> partitionProperties;

    RerouteAnalyzedStatement(ShardedTable shardedTable, List<Assignment<Symbol>> partitionProperties) {
        this.shardedTable = shardedTable;
        this.partitionProperties = partitionProperties;
    }

    public ShardedTable shardedTable() {
        return this.shardedTable;
    }

    public List<Assignment<Symbol>> partitionProperties() {
        return this.partitionProperties;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Assignment<Symbol> partitionProperty : this.partitionProperties) {
            consumer.accept((Symbol)partitionProperty.columnName());
            partitionProperty.expressions().forEach(consumer);
        }
    }
}

