/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedSwapTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.exceptions.OperationOnInaccessibleRelationException;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.role.Role;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SwapTable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class SwapTableAnalyzer {
    public static final String DROP_SOURCE = "drop_source";
    private final NodeContext nodeCtx;
    private final Schemas schemas;

    SwapTableAnalyzer(NodeContext nodeCtx, Schemas schemas) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
    }

    public AnalyzedSwapTable analyze(SwapTable<Expression> swapTable, CoordinatorTxnCtx txnCtx, ParamTypeHints typeHints) {
        Symbol dropSource;
        Map properties = swapTable.properties().toMap(HashMap::new);
        Expression dropSourceExpr = (Expression)properties.remove(DROP_SOURCE);
        if (!properties.isEmpty()) {
            throw new IllegalArgumentException("Invalid options for ALTER CLUSTER SWAP TABLE: " + String.join((CharSequence)", ", properties.keySet()));
        }
        if (dropSourceExpr == null) {
            dropSource = Literal.BOOLEAN_FALSE;
        } else {
            ExpressionAnalyzer exprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, FieldProvider.UNSUPPORTED, null);
            dropSource = exprAnalyzer.convert(dropSourceExpr, new ExpressionAnalysisContext(txnCtx.sessionSettings()));
        }
        SearchPath searchPath = txnCtx.sessionSettings().searchPath();
        Role user = txnCtx.sessionSettings().sessionUser();
        Object source = this.schemas.findRelation(swapTable.source(), Operation.ALTER_TABLE_RENAME, user, searchPath);
        if (!(source instanceof DocTableInfo)) {
            throw new OperationOnInaccessibleRelationException(source.ident(), String.format(Locale.ENGLISH, "The relation \"%s\" doesn't support or allow %s operations", new Object[]{source.ident().name(), Operation.ALTER_TABLE_RENAME}));
        }
        DocTableInfo sourceRelation = (DocTableInfo)source;
        Object target = this.schemas.findRelation(swapTable.target(), Operation.ALTER_TABLE_RENAME, user, searchPath);
        if (!(target instanceof DocTableInfo)) {
            throw new OperationOnInaccessibleRelationException(target.ident(), String.format(Locale.ENGLISH, "The relation \"%s\" doesn't support or allow %s operations", new Object[]{target.ident().name(), Operation.ALTER_TABLE_RENAME}));
        }
        DocTableInfo targetRelation = (DocTableInfo)target;
        return new AnalyzedSwapTable(sourceRelation, targetRelation, dropSource);
    }
}

