/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedUpdateStatement;
import io.crate.analyze.MaybeAliasedStatement;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.expressions.ValueNormalizer;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.NameFieldProvider;
import io.crate.analyze.relations.RelationAnalysisContext;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.relations.select.SelectAnalyzer;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.Update;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.IntegerType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class UpdateAnalyzer {
    private static final Predicate<Reference> IS_OBJECT_ARRAY = input -> {
        ArrayType arrayType;
        DataType<?> patt0$temp;
        return input != null && (patt0$temp = input.valueType()) instanceof ArrayType && (arrayType = (ArrayType)patt0$temp).innerType().id() == 12;
    };
    private final NodeContext nodeCtx;
    private final RelationAnalyzer relationAnalyzer;

    UpdateAnalyzer(NodeContext nodeCtx, RelationAnalyzer relationAnalyzer) {
        this.nodeCtx = nodeCtx;
        this.relationAnalyzer = relationAnalyzer;
    }

    public AnalyzedUpdateStatement analyze(Update update, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx) {
        StatementAnalysisContext stmtCtx = new StatementAnalysisContext(typeHints, Operation.UPDATE, txnCtx);
        RelationAnalysisContext relCtx = stmtCtx.startRelation();
        AnalyzedRelation relation = this.relationAnalyzer.analyze((Node)update.relation(), stmtCtx);
        stmtCtx.endRelation();
        MaybeAliasedStatement maybeAliasedStatement = MaybeAliasedStatement.analyze(relation);
        relation = maybeAliasedStatement.nonAliasedRelation();
        if (!(relation instanceof AbstractTableRelation)) {
            throw new UnsupportedOperationException("UPDATE is only supported on base-tables");
        }
        AbstractTableRelation table = (AbstractTableRelation)relation;
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(this.nodeCtx, RowGranularity.CLUSTER, null, table, f -> f.signature().isDeterministic());
        SubqueryAnalyzer subqueryAnalyzer = new SubqueryAnalyzer(this.relationAnalyzer, new StatementAnalysisContext(typeHints, Operation.READ, txnCtx));
        ExpressionAnalyzer sourceExprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, new FullQualifiedNameFieldProvider(relCtx.sources(), relCtx.parentSources(), txnCtx.sessionSettings().searchPath().currentSchema()), subqueryAnalyzer);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        LinkedHashMap<Reference, Symbol> assignmentByTargetCol = this.getAssignments(update.assignments(), typeHints, txnCtx, table, normalizer, subqueryAnalyzer, sourceExprAnalyzer, exprCtx);
        Symbol query = Objects.requireNonNullElse(sourceExprAnalyzer.generateQuerySymbol(update.whereClause(), exprCtx), Literal.BOOLEAN_TRUE);
        query = maybeAliasedStatement.maybeMapFields(query);
        Symbol normalizedQuery = normalizer.normalize(query, txnCtx);
        SelectAnalysis selectAnalysis = SelectAnalyzer.analyzeSelectItems(update.returningClause(), relCtx.sources(), sourceExprAnalyzer, exprCtx);
        List<Symbol> outputSymbol = selectAnalysis.outputSymbols();
        return new AnalyzedUpdateStatement(table, assignmentByTargetCol, normalizedQuery, outputSymbol.isEmpty() ? null : outputSymbol);
    }

    private LinkedHashMap<Reference, Symbol> getAssignments(List<Assignment<Expression>> assignments, ParamTypeHints typeHints, CoordinatorTxnCtx txnCtx, AbstractTableRelation<?> table, EvaluatingNormalizer normalizer, SubqueryAnalyzer subqueryAnalyzer, ExpressionAnalyzer sourceExprAnalyzer, ExpressionAnalysisContext exprCtx) {
        LinkedHashMap<Reference, Symbol> assignmentByTargetCol = new LinkedHashMap<Reference, Symbol>();
        ExpressionAnalyzer targetExprAnalyzer = new ExpressionAnalyzer(txnCtx, this.nodeCtx, typeHints, new NameFieldProvider(table), subqueryAnalyzer, Operation.UPDATE);
        assert (assignments instanceof RandomAccess) : "assignments should implement RandomAccess for indexed loop to avoid iterator allocations";
        Object tableInfo = table.tableInfo();
        ArraySetFunctionAllocator arraySetFunctionAllocator = new ArraySetFunctionAllocator((func, args) -> sourceExprAnalyzer.allocateFunction((String)func, (List<Symbol>)args, exprCtx));
        for (int i = 0; i < assignments.size(); ++i) {
            Function function;
            Assignment<Expression> assignment = assignments.get(i);
            Symbol target = normalizer.normalize(targetExprAnalyzer.convert((Expression)assignment.columnName(), exprCtx), txnCtx);
            if (target instanceof Reference) {
                Reference targetCol = (Reference)target;
                UpdateAnalyzer.rejectUpdatesToFieldsOfObjectArrays(tableInfo, targetCol, IS_OBJECT_ARRAY);
                Symbol source = ValueNormalizer.normalizeInputForReference(normalizer.normalize(sourceExprAnalyzer.convert((Expression)assignment.expression(), exprCtx), txnCtx), targetCol, tableInfo, s -> normalizer.normalize((Symbol)s, txnCtx));
                if (assignmentByTargetCol.put(targetCol, source) == null) continue;
                throw new IllegalArgumentException("Target expression repeated: " + targetCol.column().sqlFqn());
            }
            if (target instanceof Function && "subscript".equals((function = (Function)target).name())) {
                List<Symbol> args2 = function.arguments();
                Symbol baseCol = args2.get(0);
                Symbol indexToUpdate = args2.get(1);
                if (baseCol instanceof Reference) {
                    Reference targetCol = (Reference)baseCol;
                    UpdateAnalyzer.rejectUpdatesToFieldsOfObjectArrays(tableInfo, targetCol, IS_OBJECT_ARRAY);
                    assert (targetCol.valueType() instanceof ArrayType) : "targetCol should be an array type.";
                    assert (indexToUpdate.valueType() instanceof IntegerType) : "indexToUpdate should be an integer type.";
                    SimpleReference arrayElementRefForValueNormalization = new SimpleReference(targetCol.ident(), targetCol.granularity(), ((ArrayType)targetCol.valueType()).innerType(), targetCol.indexType(), targetCol.isNullable(), targetCol.hasDocValues(), targetCol.position(), targetCol.oid(), targetCol.isDropped(), targetCol.defaultExpression());
                    Symbol targetValue = ValueNormalizer.normalizeInputForReference(normalizer.normalize(sourceExprAnalyzer.convert((Expression)assignment.expression(), exprCtx), txnCtx), arrayElementRefForValueNormalization, tableInfo, s -> normalizer.normalize((Symbol)s, txnCtx));
                    arraySetFunctionAllocator.put(targetCol, indexToUpdate, targetValue);
                    continue;
                }
                Symbol symbol = baseCol.uncast();
                if (symbol instanceof Reference) {
                    Reference targetCol = (Reference)symbol;
                    UpdateAnalyzer.rejectUpdatesToFieldsOfObjectArrays(tableInfo, targetCol, IS_OBJECT_ARRAY);
                }
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "cannot use expression %s as a left side of an assignment", assignment.columnName()));
        }
        for (Map.Entry<Reference, Symbol> e : arraySetFunctionAllocator.allocate().entrySet()) {
            if (assignmentByTargetCol.put(e.getKey(), e.getValue()) == null) continue;
            throw new IllegalArgumentException("Target expression repeated: " + e.getKey().column().sqlFqn());
        }
        return assignmentByTargetCol;
    }

    private static void rejectUpdatesToFieldsOfObjectArrays(TableInfo tableInfo, Reference info, Predicate<Reference> parentMatchPredicate) {
        for (Reference parent : tableInfo.getParents(info.column())) {
            if (!parentMatchPredicate.test(parent)) continue;
            throw new IllegalArgumentException("Updating fields of object arrays is not supported");
        }
    }

    private static class ArraySetFunctionAllocator {
        private final Map<Reference, LinkedHashMap<Symbol, Symbol>> mappings;
        private final BiFunction<String, List<Symbol>, Symbol> allocateFunction;

        public ArraySetFunctionAllocator(BiFunction<String, List<Symbol>, Symbol> allocateFunction) {
            this.allocateFunction = allocateFunction;
            this.mappings = new HashMap<Reference, LinkedHashMap<Symbol, Symbol>>();
        }

        public void put(Reference reference, Symbol index, Symbol value) {
            LinkedHashMap<Symbol, Symbol> mapping = this.mappings.get(reference);
            if (mapping != null) {
                mapping.put(index, value);
            } else {
                mapping = new LinkedHashMap();
                mapping.put(index, value);
                this.mappings.put(reference, mapping);
            }
        }

        public Map<Reference, Symbol> allocate() {
            HashMap<Reference, Symbol> refToArraySetMap = new HashMap<Reference, Symbol>(this.mappings.size());
            for (Map.Entry<Reference, LinkedHashMap<Symbol, Symbol>> e : this.mappings.entrySet()) {
                Reference targetCol = e.getKey();
                LinkedHashMap<Symbol, Symbol> mapping = e.getValue();
                refToArraySetMap.put(targetCol, this.allocateFunction.apply("array_set", List.of(targetCol, this.allocateFunction.apply("_array", mapping.keySet().stream().toList()), this.allocateFunction.apply("_array", mapping.values().stream().toList()))));
            }
            return refToArraySetMap;
        }
    }
}

