/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.expressions;

import io.crate.analyze.DataTypeAnalyzer;
import io.crate.analyze.FrameBoundDefinition;
import io.crate.analyze.NegateLiterals;
import io.crate.analyze.OrderBy;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.SubscriptContext;
import io.crate.analyze.SubscriptVisitor;
import io.crate.analyze.WindowDefinition;
import io.crate.analyze.WindowFrameDefinition;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.OrderyByAnalyzer;
import io.crate.analyze.relations.SelectListFieldProvider;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.validator.SemanticSortValidator;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.ConversionException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.operator.LikeOperators;
import io.crate.expression.predicate.MatchPredicate;
import io.crate.expression.scalar.ArrayUnnestFunction;
import io.crate.expression.scalar.ExtractFunctions;
import io.crate.expression.scalar.SubscriptFunction;
import io.crate.expression.scalar.SubscriptFunctions;
import io.crate.expression.scalar.arithmetic.MapFunction;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import io.crate.interval.IntervalParser;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.table.Operation;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.Identifiers;
import io.crate.sql.parser.ParsingException;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.ArithmeticExpression;
import io.crate.sql.tree.ArrayComparison;
import io.crate.sql.tree.ArrayComparisonExpression;
import io.crate.sql.tree.ArrayLikePredicate;
import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.ArraySliceExpression;
import io.crate.sql.tree.ArraySubQueryExpression;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.BetweenPredicate;
import io.crate.sql.tree.BitString;
import io.crate.sql.tree.BitwiseExpression;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.Cast;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.sql.tree.CurrentTime;
import io.crate.sql.tree.DoubleLiteral;
import io.crate.sql.tree.EscapedCharStringLiteral;
import io.crate.sql.tree.ExistsPredicate;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Extract;
import io.crate.sql.tree.FrameBound;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.IfExpression;
import io.crate.sql.tree.InListExpression;
import io.crate.sql.tree.InPredicate;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.IntervalLiteral;
import io.crate.sql.tree.IsNotNullPredicate;
import io.crate.sql.tree.IsNullPredicate;
import io.crate.sql.tree.LikePredicate;
import io.crate.sql.tree.LogicalBinaryExpression;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.MatchPredicateColumnIdent;
import io.crate.sql.tree.NegativeExpression;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.NotExpression;
import io.crate.sql.tree.NullLiteral;
import io.crate.sql.tree.NumericLiteral;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.RecordSubscript;
import io.crate.sql.tree.SearchedCaseExpression;
import io.crate.sql.tree.SimpleCaseExpression;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SubqueryExpression;
import io.crate.sql.tree.SubscriptExpression;
import io.crate.sql.tree.TryCast;
import io.crate.sql.tree.WhenClause;
import io.crate.sql.tree.Window;
import io.crate.sql.tree.WindowFrame;
import io.crate.types.ArrayType;
import io.crate.types.BitStringType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.NumericType;
import io.crate.types.ObjectType;
import io.crate.types.UndefinedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

public class ExpressionAnalyzer {
    public static final Map<ComparisonExpression.Type, ComparisonExpression.Type> SWAP_OPERATOR_TABLE = Map.of(ComparisonExpression.Type.GREATER_THAN, ComparisonExpression.Type.LESS_THAN, ComparisonExpression.Type.LESS_THAN, ComparisonExpression.Type.GREATER_THAN, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, ComparisonExpression.Type.LESS_THAN_OR_EQUAL, ComparisonExpression.Type.LESS_THAN_OR_EQUAL, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL);
    private final CoordinatorTxnCtx coordinatorTxnCtx;
    private final ParamTypeHints paramTypeHints;
    private final FieldProvider<?> fieldProvider;
    @Nullable
    private final SubqueryAnalyzer subQueryAnalyzer;
    private final NodeContext nodeCtx;
    private final InnerExpressionAnalyzer innerAnalyzer;
    private final Operation operation;

    public ExpressionAnalyzer(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints, FieldProvider<?> fieldProvider, @Nullable SubqueryAnalyzer subQueryAnalyzer) {
        this(coordinatorTxnCtx, nodeCtx, paramTypeHints, fieldProvider, subQueryAnalyzer, Operation.READ);
    }

    public ExpressionAnalyzer(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, ParamTypeHints paramTypeHints, FieldProvider<?> fieldProvider, @Nullable SubqueryAnalyzer subQueryAnalyzer, Operation operation) {
        this.nodeCtx = nodeCtx;
        this.coordinatorTxnCtx = coordinatorTxnCtx;
        this.paramTypeHints = paramTypeHints;
        this.fieldProvider = fieldProvider;
        this.subQueryAnalyzer = subQueryAnalyzer;
        this.innerAnalyzer = new InnerExpressionAnalyzer();
        this.operation = operation;
    }

    public ExpressionAnalyzer referenceSelect(SelectAnalysis selectAnalysis) {
        SelectListFieldProvider selectListFieldProvider = new SelectListFieldProvider(selectAnalysis, this.fieldProvider);
        return new ExpressionAnalyzer(this.coordinatorTxnCtx, this.nodeCtx, this.paramTypeHints, selectListFieldProvider, this.subQueryAnalyzer, this.operation);
    }

    public Symbol convert(Expression expression, ExpressionAnalysisContext expressionAnalysisContext) {
        Symbol symbol = (Symbol)expression.accept((AstVisitor)this.innerAnalyzer, (Object)expressionAnalysisContext);
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> expressionAnalysisContext.isEagerNormalizationAllowed() && f.signature().isDeterministic());
        return normalizer.normalize(symbol, this.coordinatorTxnCtx);
    }

    public Symbol generateQuerySymbol(Optional<Expression> whereExpression, ExpressionAnalysisContext context) {
        return whereExpression.map(expression -> this.convert((Expression)expression, context)).orElse(Literal.BOOLEAN_TRUE);
    }

    private Symbol convertFunctionCall(FunctionCall node, ExpressionAnalysisContext context) {
        String name;
        ArrayList<Symbol> arguments = new ArrayList<Symbol>(node.getArguments().size());
        for (Expression expression2 : node.getArguments()) {
            Symbol argSymbol = (Symbol)expression2.accept((AstVisitor)this.innerAnalyzer, (Object)context);
            arguments.add(argSymbol);
        }
        List parts = node.getName().getParts();
        String schema = null;
        if (parts.size() == 1) {
            name = (String)parts.get(0);
        } else {
            schema = (String)parts.get(0);
            name = (String)parts.get(1);
        }
        Symbol filter = node.filter().map(expression -> this.convert((Expression)expression, context)).orElse(null);
        WindowDefinition windowDefinition = this.getWindowDefinition(node.getWindow(), context);
        if (node.isDistinct()) {
            if (arguments.size() > 1) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "%s(DISTINCT x) does not accept more than one argument", node.getName()));
            }
            Function collectSetFunction = ExpressionAnalyzer.allocateFunction("collect_set", arguments, filter, context, this.coordinatorTxnCtx, this.nodeCtx);
            String nodeName = "collection_" + name;
            List<Symbol> outerArguments = List.of(collectSetFunction);
            try {
                return this.allocateBuiltinOrUdfFunction(schema, nodeName, outerArguments, null, node.ignoreNulls(), windowDefinition, context);
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "unknown function %s(DISTINCT %s)", name, ((Symbol)arguments.get(0)).valueType()), ex);
            }
        }
        return this.allocateBuiltinOrUdfFunction(schema, name, arguments, filter, node.ignoreNulls(), windowDefinition, context);
    }

    @Nullable
    private WindowDefinition getWindowDefinition(Optional<Window> maybeWindow, ExpressionAnalysisContext context) {
        Window window;
        if (maybeWindow.isEmpty()) {
            return null;
        }
        Window unresolvedWindow = maybeWindow.get();
        if (unresolvedWindow.windowRef() != null) {
            Window refWindow = this.resolveWindowRef(unresolvedWindow.windowRef(), context.windows());
            window = unresolvedWindow.merge(refWindow);
        } else {
            window = unresolvedWindow;
        }
        ArrayList<Symbol> partitionSymbols = new ArrayList<Symbol>(window.getPartitions().size());
        for (Expression partition : window.getPartitions()) {
            Symbol symbol = this.convert(partition, context);
            SemanticSortValidator.validate(symbol, "PARTITION BY");
            partitionSymbols.add(symbol);
        }
        OrderBy orderBy = OrderyByAnalyzer.analyzeSortItems(window.getOrderBy(), sortKey -> {
            Symbol symbol = this.convert((Expression)sortKey, context);
            SemanticSortValidator.validate(symbol);
            return symbol;
        });
        WindowFrameDefinition windowFrameDefinition = WindowDefinition.RANGE_UNBOUNDED_PRECEDING_CURRENT_ROW;
        if (window.getWindowFrame().isPresent()) {
            WindowFrame windowFrame = (WindowFrame)window.getWindowFrame().get();
            this.validateFrame(window, windowFrame);
            FrameBound start = windowFrame.getStart();
            FrameBoundDefinition startBound = this.convertToAnalyzedFrameBound(context, start);
            FrameBoundDefinition endBound = windowFrame.getEnd().map(end -> this.convertToAnalyzedFrameBound(context, (FrameBound)end)).orElse(new FrameBoundDefinition(FrameBound.Type.CURRENT_ROW, Literal.NULL));
            windowFrameDefinition = new WindowFrameDefinition(windowFrame.mode(), startBound, endBound);
        }
        return new WindowDefinition(partitionSymbols, orderBy, windowFrameDefinition);
    }

    private Window resolveWindowRef(@NotNull String name, Map<String, Window> windows) {
        Window window = windows.get(name);
        if (window == null) {
            throw new IllegalArgumentException("Window " + name + " does not exist");
        }
        String windowRef = window.windowRef();
        while (windowRef != null) {
            Window refWindow = windows.get(windowRef);
            window = window.merge(refWindow);
            windowRef = refWindow.windowRef();
        }
        return window;
    }

    private void validateFrame(Window window, WindowFrame windowFrame) {
        FrameBound.Type startType = windowFrame.getStart().getType();
        if (startType.equals((Object)FrameBound.Type.FOLLOWING) || startType.equals((Object)FrameBound.Type.UNBOUNDED_FOLLOWING)) {
            throw new IllegalStateException("Frame start cannot be " + String.valueOf(startType));
        }
        if (windowFrame.mode() == WindowFrame.Mode.RANGE && startType.equals((Object)FrameBound.Type.PRECEDING) && windowFrame.getStart().getValue() != null && window.getOrderBy().size() != 1) {
            throw new IllegalStateException("RANGE with offset PRECEDING/FOLLOWING requires exactly one ORDER BY column");
        }
        windowFrame.getEnd().ifPresent(frameBound -> {
            FrameBound.Type endType = frameBound.getType();
            if (endType.equals((Object)FrameBound.Type.PRECEDING) || endType.equals((Object)FrameBound.Type.UNBOUNDED_PRECEDING)) {
                throw new IllegalStateException("Frame end cannot be " + String.valueOf(endType));
            }
            if (windowFrame.mode() == WindowFrame.Mode.RANGE && endType.equals((Object)FrameBound.Type.FOLLOWING) && ((FrameBound)windowFrame.getEnd().get()).getValue() != null && window.getOrderBy().size() != 1) {
                throw new IllegalStateException("RANGE with offset PRECEDING/FOLLOWING requires exactly one ORDER BY column");
            }
        });
    }

    private FrameBoundDefinition convertToAnalyzedFrameBound(ExpressionAnalysisContext context, FrameBound frameBound) {
        Expression offsetExpression = frameBound.getValue();
        Literal<Object> offsetSymbol = offsetExpression == null ? Literal.NULL : this.convert(offsetExpression, context);
        return new FrameBoundDefinition(frameBound.getType(), offsetSymbol);
    }

    private static List<Symbol> cast(List<Symbol> symbolsToCast, List<DataType<?>> targetTypes) {
        if (symbolsToCast.size() != targetTypes.size()) {
            throw new IllegalStateException("Given symbol list has to match the target type list.");
        }
        int size = symbolsToCast.size();
        ArrayList<Symbol> castList = new ArrayList<Symbol>(size);
        for (int i = 0; i < size; ++i) {
            Symbol symbolToCast = symbolsToCast.get(i);
            DataType<?> targetType = targetTypes.get(i);
            if (targetType.id() == 0) {
                castList.add(symbolToCast);
                continue;
            }
            castList.add(symbolToCast.cast(targetType, new CastMode[0]));
        }
        return castList;
    }

    private Symbol allocateBuiltinOrUdfFunction(String schema, String functionName, List<Symbol> arguments, Symbol filter, @Nullable Boolean ignoreNulls, WindowDefinition windowDefinition, ExpressionAnalysisContext context) {
        return ExpressionAnalyzer.allocateBuiltinOrUdfFunction(schema, functionName, arguments, filter, ignoreNulls, context, windowDefinition, this.coordinatorTxnCtx, this.nodeCtx);
    }

    public Symbol allocateFunction(String functionName, List<Symbol> arguments, ExpressionAnalysisContext context) {
        return ExpressionAnalyzer.allocateFunction(functionName, arguments, null, context, this.coordinatorTxnCtx, this.nodeCtx);
    }

    public static Function allocateFunction(String functionName, List<Symbol> arguments, @Nullable Symbol filter, ExpressionAnalysisContext context, TransactionContext txnCtx, NodeContext nodeCtx) {
        return ExpressionAnalyzer.allocateBuiltinOrUdfFunction(null, functionName, arguments, filter, null, context, null, txnCtx, nodeCtx);
    }

    private static Function allocateBuiltinOrUdfFunction(@Nullable String schema, String functionName, List<Symbol> arguments, @Nullable Symbol filter, @Nullable Boolean ignoreNulls, ExpressionAnalysisContext context, @Nullable WindowDefinition windowDefinition, TransactionContext txnCtx, NodeContext nodeCtx) {
        Function newFunction;
        FunctionImplementation funcImpl = nodeCtx.functions().get(schema, functionName, arguments, txnCtx.sessionSettings().searchPath());
        Signature signature = funcImpl.signature();
        BoundSignature boundSignature = funcImpl.boundSignature();
        List<Symbol> castArguments = ExpressionAnalyzer.cast(arguments, boundSignature.argTypes());
        if (windowDefinition == null) {
            if (signature.getType() == FunctionType.AGGREGATE) {
                context.indicateAggregates();
            } else if (filter != null) {
                throw new UnsupportedOperationException("Only aggregate functions allow a FILTER clause");
            }
            if (ignoreNulls != null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s cannot accept RESPECT or IGNORE NULLS flag.", functionName));
            }
            newFunction = new Function(signature, castArguments, boundSignature.returnType(), filter);
        } else {
            if (signature.getType() != FunctionType.WINDOW) {
                if (signature.getType() != FunctionType.AGGREGATE) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "OVER clause was specified, but %s is neither a window nor an aggregate function.", functionName));
                }
                if (ignoreNulls != null) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s cannot accept RESPECT or IGNORE NULLS flag.", functionName));
                }
            } else if (filter != null) {
                throw new UnsupportedOperationException("FILTER is not implemented for non-aggregate window functions (" + functionName + ")");
            }
            newFunction = new WindowFunction(signature, castArguments, boundSignature.returnType(), filter, windowDefinition, ignoreNulls);
        }
        return newFunction;
    }

    private static void verifyTypesForMatch(Iterable<? extends Symbol> columns, DataType<?> columnType) {
        if (!MatchPredicate.SUPPORTED_TYPES.contains(columnType)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Can only use MATCH on columns of type STRING or GEO_SHAPE, not on '%s'", columnType));
        }
        for (Symbol symbol : columns) {
            if (symbol.valueType().equals(columnType)) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "All columns within a match predicate must be of the same type. Found %s and %s", columnType, symbol.valueType()));
        }
    }

    private static void ensureResultTypesMatch(List<? extends Symbol> results) {
        HashSet resultTypes = HashSet.newHashSet(results.size() / 2);
        for (int i = 3; i < results.size(); i += 2) {
            DataType<?> type = results.get(i).valueType();
            if (type.id() == DataTypes.UNDEFINED.id()) continue;
            resultTypes.add(type);
        }
        if (resultTypes.size() > 1) {
            ArrayList errorMessage = new ArrayList(results.size() / 2);
            for (int i = 3; i < results.size(); i += 2) {
                errorMessage.add(results.get(i).valueType());
            }
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Data types of all result expressions of a CASE statement must be equal, found: %s", errorMessage));
        }
    }

    @Nullable
    private static SubscriptExpression detectAndGenerateSubscriptExpressions(String columnName) {
        int openSubscriptPos = columnName.indexOf("[");
        if (openSubscriptPos > -1) {
            String sanitizedName = Identifiers.quote((String)columnName.substring(0, openSubscriptPos)) + columnName.substring(openSubscriptPos);
            try {
                return (SubscriptExpression)SqlParser.createExpression((String)sanitizedName);
            }
            catch (ParsingException parsingException) {
                // empty catch block
            }
        }
        return null;
    }

    private class InnerExpressionAnalyzer
    extends AstVisitor<Symbol, ExpressionAnalysisContext> {
        private static final Map<IntervalLiteral.IntervalField, IntervalParser.Precision> INTERVAL_FIELDS = Map.of(IntervalLiteral.IntervalField.YEAR, IntervalParser.Precision.YEAR, IntervalLiteral.IntervalField.MONTH, IntervalParser.Precision.MONTH, IntervalLiteral.IntervalField.DAY, IntervalParser.Precision.DAY, IntervalLiteral.IntervalField.HOUR, IntervalParser.Precision.HOUR, IntervalLiteral.IntervalField.MINUTE, IntervalParser.Precision.MINUTE, IntervalLiteral.IntervalField.SECOND, IntervalParser.Precision.SECOND);

        private InnerExpressionAnalyzer() {
        }

        protected Symbol visitNode(Node node, ExpressionAnalysisContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unsupported node %s", node));
        }

        protected Symbol visitExpression(Expression node, ExpressionAnalysisContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Unsupported expression %s", ExpressionFormatter.formatStandaloneExpression((Expression)node)));
        }

        protected Symbol visitCurrentTime(CurrentTime node, ExpressionAnalysisContext context) {
            String funcName = "current_timestamp";
            switch (node.getType()) {
                case TIMESTAMP: {
                    break;
                }
                case TIME: {
                    funcName = "current_time";
                    break;
                }
                case DATE: {
                    funcName = "curdate";
                    break;
                }
                default: {
                    this.visitExpression((Expression)node, context);
                }
            }
            Optional p = node.getPrecision();
            return ExpressionAnalyzer.this.allocateFunction(funcName, p.isPresent() ? List.of(Literal.ofUnchecked(DataTypes.INTEGER, p.get())) : List.of(), context);
        }

        protected Symbol visitIfExpression(IfExpression node, ExpressionAnalysisContext context) {
            Optional defaultExpression = node.getFalseValue();
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(defaultExpression.isPresent() ? 3 : 2);
            arguments.add((Symbol)node.getCondition().accept((AstVisitor)ExpressionAnalyzer.this.innerAnalyzer, (Object)context));
            arguments.add((Symbol)node.getTrueValue().accept((AstVisitor)ExpressionAnalyzer.this.innerAnalyzer, (Object)context));
            if (defaultExpression.isPresent()) {
                arguments.add((Symbol)((Expression)defaultExpression.get()).accept((AstVisitor)ExpressionAnalyzer.this.innerAnalyzer, (Object)context));
            }
            return ExpressionAnalyzer.this.allocateFunction("if", arguments, context);
        }

        protected Symbol visitFunctionCall(FunctionCall node, ExpressionAnalysisContext context) {
            if (node.getName().toString().equalsIgnoreCase("subscript")) {
                assert (node.getArguments().size() == 2) : "Number of arguments for subscript function must be 2";
                return this.visitSubscriptExpression(new SubscriptExpression((Expression)node.getArguments().get(0), (Expression)node.getArguments().get(1)), context);
            }
            return ExpressionAnalyzer.this.convertFunctionCall(node, context);
        }

        protected Symbol visitSimpleCaseExpression(SimpleCaseExpression node, ExpressionAnalysisContext context) {
            List whenClauses = node.getWhenClauses();
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(whenClauses.size() * 2 + 2);
            Expression defaultValue = node.getDefaultValue();
            arguments.add((Symbol)BooleanLiteral.TRUE_LITERAL.accept((AstVisitor)this, (Object)context));
            if (defaultValue == null) {
                arguments.add(ExpressionAnalyzer.this.convert((Expression)NullLiteral.INSTANCE, context));
            } else {
                arguments.add(ExpressionAnalyzer.this.convert(defaultValue, context));
            }
            for (WhenClause whenClause : whenClauses) {
                arguments.add(ExpressionAnalyzer.this.allocateFunction("op_=", List.of(ExpressionAnalyzer.this.convert(node.getOperand(), context), ExpressionAnalyzer.this.convert(whenClause.getOperand(), context)), context));
                arguments.add((Symbol)whenClause.getResult().accept((AstVisitor)this, (Object)context));
            }
            ExpressionAnalyzer.ensureResultTypesMatch(arguments);
            return ExpressionAnalyzer.this.allocateFunction("case", arguments, context);
        }

        protected Symbol visitSearchedCaseExpression(SearchedCaseExpression node, ExpressionAnalysisContext context) {
            List whenClauses = node.getWhenClauses();
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(whenClauses.size() * 2 + 2);
            Expression defaultValue = node.getDefaultValue();
            arguments.add((Symbol)BooleanLiteral.TRUE_LITERAL.accept((AstVisitor)this, (Object)context));
            if (defaultValue == null) {
                arguments.add((Symbol)NullLiteral.INSTANCE.accept((AstVisitor)this, (Object)context));
            } else {
                arguments.add(ExpressionAnalyzer.this.convert(defaultValue, context));
            }
            for (WhenClause whenClause : whenClauses) {
                arguments.add((Symbol)whenClause.getOperand().accept((AstVisitor)ExpressionAnalyzer.this.innerAnalyzer, (Object)context));
                arguments.add((Symbol)whenClause.getResult().accept((AstVisitor)ExpressionAnalyzer.this.innerAnalyzer, (Object)context));
            }
            ExpressionAnalyzer.ensureResultTypesMatch(arguments);
            return ExpressionAnalyzer.this.allocateFunction("case", arguments, context);
        }

        protected Symbol visitCast(Cast node, ExpressionAnalysisContext context) {
            Symbol expression = (Symbol)node.getExpression().accept((AstVisitor)this, (Object)context);
            DataType<Integer> returnType = DataTypeAnalyzer.convert(node.getType());
            DataType<?> valueType = expression.valueType();
            DataType<?> unnestedReturnType = ArrayType.unnest(returnType);
            DataType<?> unnestedValueType = ArrayType.unnest(valueType);
            if (unnestedReturnType.id() == 12 && unnestedValueType.id() == 12 && unnestedReturnType.columnPolicy() != ColumnPolicy.STRICT) {
                returnType = DataTypes.merge(valueType, returnType, returnType.columnPolicy());
            }
            if (node.isIntegerOnly() && !returnType.isConvertableTo(DataTypes.INTEGER, false)) {
                throw new IllegalArgumentException("Cannot cast to a datatype that is not convertible to `integer`");
            }
            return expression.cast(returnType, CastMode.EXPLICIT);
        }

        protected Symbol visitTryCast(TryCast node, ExpressionAnalysisContext context) {
            DataType<Integer> returnType = DataTypeAnalyzer.convert(node.getType());
            if (node.isIntegerOnly() && !returnType.isConvertableTo(DataTypes.INTEGER, false)) {
                throw new IllegalArgumentException("Cannot cast to a datatype that is not convertible to `integer`");
            }
            try {
                return ((Symbol)node.getExpression().accept((AstVisitor)this, (Object)context)).cast(returnType, CastMode.EXPLICIT, CastMode.TRY);
            }
            catch (ConversionException e) {
                return Literal.NULL;
            }
        }

        protected Symbol visitExtract(Extract node, ExpressionAnalysisContext context) {
            Symbol expression = (Symbol)node.getExpression().accept((AstVisitor)this, (Object)context);
            return ExpressionAnalyzer.this.allocateFunction(ExtractFunctions.functionNameFrom(node.getField()), List.of(expression), context);
        }

        protected Symbol visitInPredicate(InPredicate node, ExpressionAnalysisContext context) {
            Expression arrayExpression;
            Expression valueList = node.getValueList();
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                List expressions = inListExpression.getValues();
                arrayExpression = new ArrayLiteral(expressions);
            } else {
                arrayExpression = node.getValueList();
            }
            ArrayComparisonExpression arrayComparisonExpression = new ArrayComparisonExpression(ComparisonExpression.Type.EQUAL, ArrayComparison.Quantifier.ANY, node.getValue(), arrayExpression);
            return (Symbol)arrayComparisonExpression.accept((AstVisitor)this, (Object)context);
        }

        protected Symbol visitArraySubQueryExpression(ArraySubQueryExpression node, ExpressionAnalysisContext context) {
            SubqueryExpression subqueryExpression = node.subqueryExpression();
            context.registerArrayChild((Expression)subqueryExpression);
            return (Symbol)subqueryExpression.accept((AstVisitor)this, (Object)context);
        }

        protected Symbol visitIsNotNullPredicate(IsNotNullPredicate node, ExpressionAnalysisContext context) {
            Symbol argument = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            return ExpressionAnalyzer.this.allocateFunction("op_not", List.of(ExpressionAnalyzer.this.allocateFunction("op_isnull", List.of(argument), context)), context);
        }

        protected Symbol visitExists(ExistsPredicate node, ExpressionAnalysisContext context) {
            if (ExpressionAnalyzer.this.subQueryAnalyzer == null) {
                throw new UnsupportedOperationException("Subquery not supported in this statement");
            }
            AnalyzedRelation relation = ExpressionAnalyzer.this.subQueryAnalyzer.analyze(node.getSubquery());
            List<Symbol> fields = relation.outputs();
            if (fields.size() > 1) {
                throw new UnsupportedOperationException("Subqueries with more than 1 column are not supported");
            }
            DataType<?> innerType = fields.getFirst().valueType();
            SelectSymbol selectSymbol = new SelectSymbol(relation, new ArrayType(innerType), SelectSymbol.ResultType.SINGLE_COLUMN_EXISTS, false);
            return ExpressionAnalyzer.this.allocateFunction("_exists", List.of(selectSymbol), context);
        }

        protected Symbol visitSubscriptExpression(SubscriptExpression node, ExpressionAnalysisContext context) {
            Object ref;
            SubscriptContext subscriptContext = SubscriptVisitor.visit((Expression)node);
            if (subscriptContext.hasExpression()) {
                Function optimizedSubscript;
                Symbol base = (Symbol)node.base().accept((AstVisitor)this, (Object)context);
                Symbol index = (Symbol)node.index().accept((AstVisitor)this, (Object)context);
                if (index.valueType() == DataTypes.STRING && !subscriptContext.parts().isEmpty() && (optimizedSubscript = this.optimizedSubscriptFunction(base, index, List.of(subscriptContext.parts().getLast()), context, null)) != null) {
                    return optimizedSubscript;
                }
                return ExpressionAnalyzer.this.allocateFunction("subscript", List.of(base, index), context);
            }
            QualifiedName qualifiedName = subscriptContext.qualifiedName();
            String columnName = qualifiedName.getSuffix();
            SubscriptExpression maybeQuotedSubscript = ExpressionAnalyzer.detectAndGenerateSubscriptExpressions(columnName);
            if (maybeQuotedSubscript != null) {
                return this.visitSubscriptExpression(new SubscriptExpression((Expression)maybeQuotedSubscript, node.index()), context);
            }
            List<String> parts = subscriptContext.parts();
            try {
                ref = ExpressionAnalyzer.this.fieldProvider.resolveField(qualifiedName, parts, ExpressionAnalyzer.this.operation, context.errorOnUnknownObjectKey());
            }
            catch (ColumnUnknownException e) {
                return this.resolveUnindexedSubscriptExpression(node, context, qualifiedName, parts, e);
            }
            for (Expression idx : subscriptContext.index()) {
                Symbol index = (Symbol)idx.accept((AstVisitor)this, (Object)context);
                ref = ExpressionAnalyzer.this.allocateFunction("subscript", List.of(ref, index), context);
            }
            return ref;
        }

        private Symbol resolveUnindexedSubscriptExpression(SubscriptExpression node, ExpressionAnalysisContext context, QualifiedName qualifiedName, List<String> parts, ColumnUnknownException e) {
            if (ExpressionAnalyzer.this.operation != Operation.READ || parts.isEmpty()) {
                throw e;
            }
            Symbol parent = null;
            List<String> childParts = parts;
            for (int i = parts.size() - 1; i >= 0; --i) {
                List<String> parentParts = parts.subList(0, i);
                try {
                    parent = (Symbol)ExpressionAnalyzer.this.fieldProvider.resolveField(qualifiedName, parentParts, ExpressionAnalyzer.this.operation, context.errorOnUnknownObjectKey());
                    childParts = parts.subList(i, parts.size());
                    break;
                }
                catch (ColumnUnknownException e2) {
                    if (i != 0) continue;
                    throw e;
                }
            }
            assert (parent != null) : "Parent symbol must not be null without throwing an exception";
            try {
                Symbol index = (Symbol)node.index().accept((AstVisitor)this, (Object)context);
                Function optimizedSubscript = this.optimizedSubscriptFunction(parent, index, childParts, context, e);
                if (optimizedSubscript != null) {
                    return optimizedSubscript;
                }
                return ExpressionAnalyzer.this.allocateFunction("subscript", List.of(parent, index), context);
            }
            catch (ColumnUnknownException e2) {
                throw e;
            }
        }

        @Nullable
        private Function optimizedSubscriptFunction(Symbol base, Symbol index, List<String> path, ExpressionAnalysisContext context, @Nullable ColumnUnknownException e) {
            if (path.isEmpty()) {
                return null;
            }
            DataType<?> baseType = base.valueType();
            DataType<?> innerType = DataTypes.innerType(baseType, path);
            if (innerType != null && innerType != UndefinedType.INSTANCE && !DataTypes.isArrayOfNulls(innerType)) {
                Signature signature = SubscriptFunction.SIGNATURE_OBJECT;
                if (baseType instanceof ArrayType) {
                    signature = SubscriptFunction.SIGNATURE_ARRAY_OF_OBJECTS;
                }
                return new Function(signature, List.of(base, index), innerType);
            }
            DataType<?> currentType = baseType;
            ColumnPolicy parentPolicy = baseType.columnPolicy();
            for (String p : path) {
                DataType<?> dataType = ArrayType.unnest(currentType);
                if (!(dataType instanceof ObjectType)) continue;
                ObjectType objectType = (ObjectType)dataType;
                parentPolicy = objectType.columnPolicy();
                currentType = objectType.innerType(p);
            }
            if (parentPolicy == ColumnPolicy.STRICT || parentPolicy == ColumnPolicy.DYNAMIC && context.errorOnUnknownObjectKey()) {
                if (e != null) {
                    throw e;
                }
                throw ColumnUnknownException.forSubscript(base, path.getLast());
            }
            return null;
        }

        protected Symbol visitArraySliceExpression(ArraySliceExpression node, ExpressionAnalysisContext context) {
            Symbol base = (Symbol)node.getBase().accept((AstVisitor)this, (Object)context);
            Symbol from = node.getFrom().map(f -> (Symbol)f.accept((AstVisitor)this, (Object)context)).orElse(Literal.NULL);
            Symbol to = node.getTo().map(f -> (Symbol)f.accept((AstVisitor)this, (Object)context)).orElse(Literal.NULL);
            return ExpressionAnalyzer.this.allocateFunction("array_slice", List.of(base, from, to), context);
        }

        protected Symbol visitLogicalBinaryExpression(LogicalBinaryExpression node, ExpressionAnalysisContext context) {
            String name = switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case LogicalBinaryExpression.Type.AND -> "op_and";
                case LogicalBinaryExpression.Type.OR -> "op_or";
            };
            List<Symbol> arguments = List.of((Symbol)node.getLeft().accept((AstVisitor)this, (Object)context), (Symbol)node.getRight().accept((AstVisitor)this, (Object)context));
            return ExpressionAnalyzer.this.allocateFunction(name, arguments, context);
        }

        protected Symbol visitNotExpression(NotExpression node, ExpressionAnalysisContext context) {
            Symbol argument = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            return ExpressionAnalyzer.this.allocateFunction("op_not", List.of(argument), context);
        }

        protected Symbol visitComparisonExpression(ComparisonExpression node, ExpressionAnalysisContext context) {
            Symbol left = (Symbol)node.getLeft().accept((AstVisitor)this, (Object)context);
            Symbol right = (Symbol)node.getRight().accept((AstVisitor)this, (Object)context);
            Comparison comparison = new Comparison(ExpressionAnalyzer.this.coordinatorTxnCtx, ExpressionAnalyzer.this.nodeCtx, node.getType(), left, right);
            comparison.normalize(context);
            return ExpressionAnalyzer.this.allocateFunction(comparison.operatorName, comparison.arguments(), context);
        }

        public Symbol visitArrayComparisonExpression(ArrayComparisonExpression node, ExpressionAnalysisContext context) {
            context.registerArrayChild(node.getRight());
            context.parentIsOrderSensitive(false);
            Symbol leftSymbol = (Symbol)node.getLeft().accept((AstVisitor)this, (Object)context);
            Symbol arraySymbol = (Symbol)node.getRight().accept((AstVisitor)this, (Object)context);
            int leftDimensions = ArrayType.dimensions(leftSymbol.valueType());
            int rightDimensions = ArrayType.dimensions(arraySymbol.valueType());
            int diff = rightDimensions - leftDimensions;
            arraySymbol = ArrayUnnestFunction.unnest(arraySymbol, diff - 1);
            context.parentIsOrderSensitive(true);
            ComparisonExpression.Type operationType = node.getType();
            String operatorName = switch (node.quantifier()) {
                default -> throw new MatchException(null, null);
                case ArrayComparison.Quantifier.ANY -> "any_" + operationType.getValue();
                case ArrayComparison.Quantifier.ALL -> "_all_" + operationType.getValue();
            };
            return ExpressionAnalyzer.this.allocateFunction(operatorName, List.of(leftSymbol, arraySymbol), context);
        }

        public Symbol visitArrayLikePredicate(ArrayLikePredicate node, ExpressionAnalysisContext context) {
            if (node.getEscape() != null) {
                throw new UnsupportedOperationException("ESCAPE is not supported.");
            }
            Symbol value = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            Symbol pattern = (Symbol)node.getPattern().accept((AstVisitor)this, (Object)context);
            int valueDimensions = ArrayType.dimensions(value.valueType());
            int patternDimensions = ArrayType.dimensions(pattern.valueType());
            int diff = valueDimensions - patternDimensions;
            value = ArrayUnnestFunction.unnest(value, diff - 1);
            return ExpressionAnalyzer.this.allocateFunction(LikeOperators.arrayOperatorName(node.quantifier(), node.inverse(), node.ignoreCase()), List.of(pattern, value), context);
        }

        protected Symbol visitLikePredicate(LikePredicate node, ExpressionAnalysisContext context) {
            Symbol expression = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            Symbol pattern = (Symbol)node.getPattern().accept((AstVisitor)this, (Object)context);
            if (node.getEscape() != null) {
                Symbol escape = (Symbol)node.getEscape().accept((AstVisitor)this, (Object)context);
                return ExpressionAnalyzer.this.allocateFunction(LikeOperators.likeOperatorName(node.ignoreCase()), List.of(expression, pattern, escape), context);
            }
            return ExpressionAnalyzer.this.allocateFunction(LikeOperators.likeOperatorName(node.ignoreCase()), List.of(expression, pattern), context);
        }

        protected Symbol visitIsNullPredicate(IsNullPredicate node, ExpressionAnalysisContext context) {
            Symbol value = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            return ExpressionAnalyzer.this.allocateFunction("op_isnull", List.of(value), context);
        }

        protected Symbol visitNegativeExpression(NegativeExpression node, ExpressionAnalysisContext context) {
            Symbol value = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            Symbol returnSymbol = NegateLiterals.negate(value);
            if (returnSymbol != null) {
                return returnSymbol;
            }
            return ExpressionAnalyzer.this.allocateFunction("_negate", List.of(value), context);
        }

        protected Symbol visitArithmeticExpression(ArithmeticExpression node, ExpressionAnalysisContext context) {
            Symbol left = (Symbol)node.getLeft().accept((AstVisitor)this, (Object)context);
            Symbol right = (Symbol)node.getRight().accept((AstVisitor)this, (Object)context);
            return ExpressionAnalyzer.this.allocateFunction(node.getType().name().toLowerCase(Locale.ENGLISH), List.of(left, right), context);
        }

        protected Symbol visitBitwiseExpression(BitwiseExpression node, ExpressionAnalysisContext context) {
            Symbol left = (Symbol)node.getLeft().accept((AstVisitor)this, (Object)context);
            Symbol right = (Symbol)node.getRight().accept((AstVisitor)this, (Object)context);
            return ExpressionAnalyzer.this.allocateFunction(node.getType().name().toLowerCase(Locale.ENGLISH), List.of(left, right), context);
        }

        public Symbol visitRecordSubscript(RecordSubscript recordSubscript, ExpressionAnalysisContext context) {
            Expression base = recordSubscript.base();
            String field = recordSubscript.field();
            ArrayList<String> reversedPath = new ArrayList<String>();
            reversedPath.add(field);
            while (base instanceof RecordSubscript) {
                RecordSubscript subscript = (RecordSubscript)base;
                base = subscript.base();
                reversedPath.add(subscript.field());
            }
            List path = Lists.reverse(reversedPath);
            if (base instanceof QualifiedNameReference) {
                QualifiedNameReference qnr = (QualifiedNameReference)base;
                QualifiedName name = qnr.getName();
                try {
                    return ExpressionAnalyzer.this.fieldProvider.resolveField(name, path, ExpressionAnalyzer.this.operation, context.errorOnUnknownObjectKey());
                }
                catch (ColumnUnknownException e) {
                    Object baseSymbol = ExpressionAnalyzer.this.fieldProvider.resolveField(name, List.of(), ExpressionAnalyzer.this.operation, context.errorOnUnknownObjectKey());
                    Function subscriptFunction = SubscriptFunctions.tryCreateSubscript(baseSymbol, path);
                    if (subscriptFunction == null) {
                        throw e;
                    }
                    return subscriptFunction;
                }
            }
            Symbol baseSymbol = (Symbol)base.accept((AstVisitor)this, (Object)context);
            Function subscriptFunction = SubscriptFunctions.tryCreateSubscript(baseSymbol, path);
            if (subscriptFunction == null) {
                throw new UnsupportedOperationException("Unsupported expression `" + ExpressionFormatter.formatStandaloneExpression((Expression)recordSubscript) + "`, `" + ExpressionFormatter.formatStandaloneExpression((Expression)base) + "` should have type `object` or `record` but was `" + baseSymbol.valueType().getName() + "`");
            }
            return subscriptFunction;
        }

        protected Symbol visitQualifiedNameReference(QualifiedNameReference node, ExpressionAnalysisContext context) {
            QualifiedName qualifiedName = node.getName();
            List parts = qualifiedName.getParts();
            String columnName = (String)parts.getLast();
            SubscriptExpression maybeQuotedSubscript = ExpressionAnalyzer.detectAndGenerateSubscriptExpressions(columnName);
            if (maybeQuotedSubscript != null) {
                return this.visitSubscriptExpression(maybeQuotedSubscript, context);
            }
            return ExpressionAnalyzer.this.fieldProvider.resolveField(node.getName(), null, ExpressionAnalyzer.this.operation, context.errorOnUnknownObjectKey());
        }

        protected Symbol visitBooleanLiteral(BooleanLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        protected Symbol visitStringLiteral(StringLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        public Symbol visitBitString(BitString bitString, ExpressionAnalysisContext context) {
            BitStringType bitStringType = new BitStringType(bitString.length());
            return Literal.of(bitStringType, bitString);
        }

        protected Symbol visitEscapedCharStringLiteral(EscapedCharStringLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        protected Symbol visitDoubleLiteral(DoubleLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        protected Symbol visitLongLiteral(LongLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        protected Symbol visitIntegerLiteral(IntegerLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(node.getValue());
        }

        public Symbol visitNumericLiteral(NumericLiteral numericLiteral, ExpressionAnalysisContext context) {
            BigDecimal value = numericLiteral.value();
            NumericType numericType = new NumericType(value.precision(), value.scale());
            return Literal.of(numericType, value);
        }

        protected Symbol visitNullLiteral(NullLiteral node, ExpressionAnalysisContext context) {
            return Literal.of(UndefinedType.INSTANCE, null);
        }

        public Symbol visitArrayLiteral(ArrayLiteral node, ExpressionAnalysisContext context) {
            List values = node.values();
            if (values.isEmpty()) {
                return Literal.of(new ArrayType<Object>(UndefinedType.INSTANCE), List.of());
            }
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(values.size());
            for (Expression value : values) {
                arguments.add((Symbol)value.accept((AstVisitor)this, (Object)context));
            }
            return ExpressionAnalyzer.this.allocateFunction("_array", arguments, context);
        }

        public Symbol visitObjectLiteral(ObjectLiteral node, ExpressionAnalysisContext context) {
            Map values = node.values();
            if (values.isEmpty()) {
                return Literal.EMPTY_OBJECT;
            }
            ArrayList<Symbol> arguments = new ArrayList<Symbol>(values.size() * 2);
            ObjectType.Builder returnTypeBuilder = ObjectType.of(ColumnPolicy.DYNAMIC);
            for (Map.Entry entry : values.entrySet()) {
                Symbol val = (Symbol)((Expression)entry.getValue()).accept((AstVisitor)this, (Object)context);
                arguments.add(Literal.of((String)entry.getKey()));
                arguments.add(val);
                returnTypeBuilder.setInnerType((String)entry.getKey(), val.valueType());
            }
            return new Function(MapFunction.SIGNATURE, arguments, returnTypeBuilder.build());
        }

        public Symbol visitIntervalLiteral(IntervalLiteral node, ExpressionAnalysisContext context) {
            String value = node.getValue();
            IntervalParser.Precision start = INTERVAL_FIELDS.get(node.getStartField());
            IntervalParser.Precision end = node.getEndField() == null ? null : INTERVAL_FIELDS.get(node.getEndField());
            Period period = IntervalParser.apply(value, start, end);
            if (node.getSign() == IntervalLiteral.Sign.MINUS) {
                period = period.negated();
            }
            return Literal.newInterval(period);
        }

        public Symbol visitParameterExpression(ParameterExpression node, ExpressionAnalysisContext context) {
            return ExpressionAnalyzer.this.paramTypeHints.apply(node);
        }

        protected Symbol visitBetweenPredicate(BetweenPredicate node, ExpressionAnalysisContext context) {
            Symbol value = (Symbol)node.getValue().accept((AstVisitor)this, (Object)context);
            Symbol min = (Symbol)node.getMin().accept((AstVisitor)this, (Object)context);
            Symbol max = (Symbol)node.getMax().accept((AstVisitor)this, (Object)context);
            Comparison gte = new Comparison(ExpressionAnalyzer.this.coordinatorTxnCtx, ExpressionAnalyzer.this.nodeCtx, ComparisonExpression.Type.GREATER_THAN_OR_EQUAL, value, min);
            Comparison normalizedGte = gte.normalize(context);
            Symbol gteFunc = ExpressionAnalyzer.this.allocateFunction(normalizedGte.operatorName, normalizedGte.arguments(), context);
            Comparison lte = new Comparison(ExpressionAnalyzer.this.coordinatorTxnCtx, ExpressionAnalyzer.this.nodeCtx, ComparisonExpression.Type.LESS_THAN_OR_EQUAL, value, max);
            Comparison normalizedLte = lte.normalize(context);
            Symbol lteFunc = ExpressionAnalyzer.this.allocateFunction(normalizedLte.operatorName, normalizedLte.arguments(), context);
            return ExpressionAnalyzer.this.allocateFunction("op_and", List.of(gteFunc, lteFunc), context);
        }

        public Symbol visitMatchPredicate(io.crate.sql.tree.MatchPredicate node, ExpressionAnalysisContext context) {
            HashMap<Symbol, Symbol> identBoostMap = HashMap.newHashMap(node.idents().size());
            DataType<?> columnType = null;
            HashSet<RelationName> relationsInColumns = new HashSet<RelationName>();
            for (MatchPredicateColumnIdent ident : node.idents()) {
                Symbol column = (Symbol)ident.columnIdent().accept((AstVisitor)this, (Object)context);
                if (columnType == null) {
                    columnType = column.valueType();
                }
                if (!(column instanceof ScopedSymbol) && !(column instanceof Reference)) {
                    throw new IllegalArgumentException(Symbols.format("can only MATCH on columns, not on %s", column));
                }
                Symbol boost = (Symbol)ident.boost().accept((AstVisitor)this, (Object)context);
                identBoostMap.put(column, boost);
                if (!(column instanceof ScopedSymbol)) continue;
                ScopedSymbol scopedSymbol = (ScopedSymbol)column;
                relationsInColumns.add(scopedSymbol.relation());
            }
            if (relationsInColumns.size() > 1) {
                throw new IllegalArgumentException("Cannot use MATCH predicates on columns of 2 different relations");
            }
            assert (columnType != null) : "columnType must not be null";
            ExpressionAnalyzer.verifyTypesForMatch(identBoostMap.keySet(), columnType);
            Symbol queryTerm = ((Symbol)node.value().accept((AstVisitor)this, (Object)context)).cast(columnType, new CastMode[0]);
            String matchType = MatchPredicate.getMatchType(node.matchType(), columnType);
            ArrayList<Symbol> mapArgs = new ArrayList<Symbol>(node.properties().size() * 2);
            for (Map.Entry e : node.properties()) {
                mapArgs.add(Literal.of((String)e.getKey()));
                mapArgs.add((Symbol)((Expression)e.getValue()).accept((AstVisitor)this, (Object)context));
            }
            Literal<Map<String, Object>> options = mapArgs.isEmpty() ? Literal.of(Map.of()) : ExpressionAnalyzer.this.allocateFunction("_map", mapArgs, context);
            return new io.crate.expression.symbol.MatchPredicate(identBoostMap, queryTerm, matchType, options);
        }

        protected Symbol visitSubqueryExpression(SubqueryExpression node, ExpressionAnalysisContext context) {
            if (ExpressionAnalyzer.this.subQueryAnalyzer == null) {
                throw new UnsupportedOperationException("Subquery not supported in this statement");
            }
            AnalyzedRelation relation = ExpressionAnalyzer.this.subQueryAnalyzer.analyze(node.getQuery());
            List<Symbol> fields = relation.outputs();
            if (fields.size() > 1) {
                throw new UnsupportedOperationException("Subqueries with more than 1 column are not supported.");
            }
            DataType<?> innerType = fields.getFirst().valueType();
            ArrayType dataType = new ArrayType(innerType);
            SelectSymbol.ResultType resultType = context.isArrayChild(node) ? SelectSymbol.ResultType.SINGLE_COLUMN_MULTIPLE_VALUES : SelectSymbol.ResultType.SINGLE_COLUMN_SINGLE_VALUE;
            return new SelectSymbol(relation, dataType, resultType, context.parentIsOrderSensitive());
        }
    }

    private static class Comparison {
        private final CoordinatorTxnCtx coordinatorTxnCtx;
        private final NodeContext nodeCtx;
        private ComparisonExpression.Type comparisonExpressionType;
        private Symbol left;
        private Symbol right;
        private String operatorName;

        private Comparison(CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, ComparisonExpression.Type comparisonExpressionType, Symbol left, Symbol right) {
            this.coordinatorTxnCtx = coordinatorTxnCtx;
            this.nodeCtx = nodeCtx;
            this.operatorName = "op_" + comparisonExpressionType.getValue();
            this.comparisonExpressionType = comparisonExpressionType;
            this.left = left;
            this.right = right;
        }

        Comparison normalize(ExpressionAnalysisContext context) {
            this.swapIfNecessary();
            this.rewriteNegatingOperators(context);
            return this;
        }

        private void swapIfNecessary() {
            if ((!(this.right instanceof Reference) && !(this.right instanceof ScopedSymbol) || this.left instanceof Reference || this.left instanceof ScopedSymbol) && this.left.valueType().id() != DataTypes.UNDEFINED.id()) {
                return;
            }
            ComparisonExpression.Type type = SWAP_OPERATOR_TABLE.get(this.comparisonExpressionType);
            if (type != null) {
                this.comparisonExpressionType = type;
                this.operatorName = "op_" + type.getValue();
            }
            Symbol tmp = this.left;
            this.left = this.right;
            this.right = tmp;
        }

        private void rewriteNegatingOperators(ExpressionAnalysisContext context) {
            String opName;
            switch (this.comparisonExpressionType) {
                case NOT_EQUAL: {
                    opName = "op_=";
                    break;
                }
                case REGEX_NO_MATCH: {
                    opName = "op_~";
                    break;
                }
                case REGEX_NO_MATCH_CI: {
                    opName = "op_~*";
                    break;
                }
                default: {
                    return;
                }
            }
            this.left = ExpressionAnalyzer.allocateFunction(opName, List.of(this.left, this.right), null, context, this.coordinatorTxnCtx, this.nodeCtx);
            this.right = null;
            this.operatorName = "op_not";
        }

        List<Symbol> arguments() {
            if (this.right == null) {
                return List.of(this.left);
            }
            return List.of(this.left, this.right);
        }
    }
}

