/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.AnalyzedShowCreateTable;
import io.crate.analyze.ExplainAnalyzedStatement;
import io.crate.analyze.JoinRelation;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.PlannedRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.fdw.ForeignTableRelation;
import java.util.Locale;

public abstract class AnalyzedRelationVisitor<C, R> {
    protected R visitAnalyzedRelation(AnalyzedRelation relation, C context) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "relation \"%s\" is not supported by %s", relation, this.getClass().getSimpleName()));
    }

    public R visitUnionSelect(UnionSelect unionSelect, C context) {
        unionSelect.left().accept(this, context);
        unionSelect.right().accept(this, context);
        return null;
    }

    public R visitTableRelation(TableRelation tableRelation, C context) {
        return this.visitAnalyzedRelation(tableRelation, context);
    }

    public R visitDocTableRelation(DocTableRelation relation, C context) {
        return this.visitAnalyzedRelation(relation, context);
    }

    public R visitPlannedRelation(PlannedRelation relation, C context) {
        return this.visitAnalyzedRelation(relation, context);
    }

    public R visitExplain(ExplainAnalyzedStatement explainAnalyzedStatement, C context) {
        return this.visitAnalyzedRelation(explainAnalyzedStatement, context);
    }

    public R visitTableFunctionRelation(TableFunctionRelation tableFunctionRelation, C context) {
        return this.visitAnalyzedRelation(tableFunctionRelation, context);
    }

    public R visitQueriedSelectRelation(QueriedSelectRelation relation, C context) {
        for (AnalyzedRelation from : relation.from()) {
            from.accept(this, context);
        }
        return null;
    }

    public R visitView(AnalyzedView analyzedView, C context) {
        return analyzedView.relation().accept(this, context);
    }

    public R visitAliasedAnalyzedRelation(AliasedAnalyzedRelation relation, C context) {
        return relation.relation().accept(this, context);
    }

    public R visitShowCreateTable(AnalyzedShowCreateTable analyzedShowCreateTable, C context) {
        return this.visitAnalyzedRelation(analyzedShowCreateTable, context);
    }

    public R visitForeignTable(ForeignTableRelation foreignTableRelation, C context) {
        return this.visitAnalyzedRelation(foreignTableRelation, context);
    }

    public R visitJoinRelation(JoinRelation joinRelation, C context) {
        joinRelation.left().accept(this, context);
        joinRelation.right().accept(this, context);
        return null;
    }
}

