/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.ParentRelations;
import io.crate.metadata.RelationName;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class RelationAnalysisContext {
    private final ExpressionAnalysisContext expressionAnalysisContext;
    private final boolean aliasedRelation;
    private final ParentRelations parents;
    private final Map<RelationName, AnalyzedRelation> sources = new LinkedHashMap<RelationName, AnalyzedRelation>();

    RelationAnalysisContext(boolean aliasedRelation, ParentRelations parents, CoordinatorSessionSettings sessionSettings) {
        this.aliasedRelation = aliasedRelation;
        this.parents = parents;
        this.expressionAnalysisContext = new ExpressionAnalysisContext(sessionSettings);
    }

    boolean isAliasedRelation() {
        return this.aliasedRelation;
    }

    public Map<RelationName, AnalyzedRelation> sources() {
        return this.sources;
    }

    void addSourceRelation(AnalyzedRelation relation) {
        RelationName relationName = relation.relationName();
        if (this.sources.put(relationName, relation) != null) {
            String errorMessage = String.format(Locale.ENGLISH, "\"%s\" specified more than once in the FROM clause", relationName);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public ExpressionAnalysisContext expressionAnalysisContext() {
        return this.expressionAnalysisContext;
    }

    public ParentRelations parentSources() {
        return this.parents;
    }
}

