/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.exceptions.AmbiguousColumnAliasException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SelectListFieldProvider
implements FieldProvider<Symbol> {
    private final SelectAnalysis selectAnalysis;
    private final FieldProvider<? extends Symbol> fallback;

    public SelectListFieldProvider(SelectAnalysis selectAnalysis, FieldProvider<? extends Symbol> fallback) {
        this.selectAnalysis = selectAnalysis;
        this.fallback = fallback;
    }

    @Override
    public Symbol resolveField(QualifiedName qualifiedName, List<String> path, Operation operation, boolean errorOnUnknownObjectKey) {
        List parts = qualifiedName.getParts();
        if (parts.size() == 1 && (path == null || path.isEmpty())) {
            String part = (String)parts.get(0);
            Symbol result = SelectListFieldProvider.getOneOrAmbiguous(this.selectAnalysis.outputMultiMap(), part);
            if (result != null) {
                return result;
            }
        }
        return this.fallback.resolveField(qualifiedName, path, operation, errorOnUnknownObjectKey);
    }

    @Nullable
    public static Symbol getOneOrAmbiguous(Map<String, Set<Symbol>> selectList, String key) throws AmbiguousColumnAliasException {
        Collection symbols = selectList.get(key);
        if (symbols == null) {
            return null;
        }
        if (symbols.size() > 1) {
            throw new AmbiguousColumnAliasException(key, symbols);
        }
        return (Symbol)symbols.iterator().next();
    }
}

