/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations.select;

import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.sql.tree.Expression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SelectAnalysis {
    private final Map<RelationName, AnalyzedRelation> sources;
    private final ExpressionAnalyzer expressionAnalyzer;
    private final ExpressionAnalysisContext expressionAnalysisContext;
    private final List<Symbol> outputSymbols;
    private final List<String> outputNames;
    private final Map<String, Set<Symbol>> outputMap;

    public SelectAnalysis(int expectedItems, Map<RelationName, AnalyzedRelation> sources, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        this.sources = sources;
        this.expressionAnalyzer = expressionAnalyzer;
        this.expressionAnalysisContext = expressionAnalysisContext;
        this.outputMap = new HashMap<String, Set<Symbol>>();
        this.outputSymbols = new ArrayList<Symbol>(expectedItems);
        this.outputNames = new ArrayList<String>(expectedItems);
    }

    public List<Symbol> outputSymbols() {
        return this.outputSymbols;
    }

    Symbol toSymbol(Expression expression) {
        return this.expressionAnalyzer.convert(expression, this.expressionAnalysisContext);
    }

    public Map<RelationName, AnalyzedRelation> sources() {
        return this.sources;
    }

    public Map<String, Set<Symbol>> outputMultiMap() {
        return this.outputMap;
    }

    public List<String> outputColumnNames() {
        return this.outputNames;
    }

    public void add(ColumnIdent path, Symbol symbol, @Nullable String name) {
        this.outputSymbols.add(symbol);
        this.outputNames.add(name == null ? path.sqlFqn() : name);
        Set<Symbol> symbols = this.outputMap.get(path.sqlFqn());
        if (symbols == null) {
            symbols = new HashSet<Symbol>();
        }
        symbols.add(symbol);
        this.outputMap.put(path.sqlFqn(), symbols);
    }
}

