/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.validator;

import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import java.util.Collection;
import java.util.Locale;

public class SelectSymbolValidator {
    private static final InnerValidator INNER_VALIDATOR = new InnerValidator();

    public static void validate(Collection<Symbol> symbols) {
        for (Symbol symbol : symbols) {
            symbol.accept(INNER_VALIDATOR, null);
        }
    }

    private static class InnerValidator
    extends SymbolVisitor<Void, Void> {
        private InnerValidator() {
        }

        @Override
        public Void visitFunction(Function symbol, Void context) {
            switch (symbol.signature().getType()) {
                case SCALAR: 
                case AGGREGATE: 
                case TABLE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "FunctionInfo.Type %s not handled", new Object[]{symbol.signature().getType()}));
                }
            }
            for (Symbol arg : symbol.arguments()) {
                arg.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitMatchPredicate(MatchPredicate matchPredicate, Void context) {
            throw new UnsupportedOperationException("match predicate cannot be selected");
        }

        @Override
        public Void visitSymbol(Symbol symbol, Void context) {
            return null;
        }

        @Override
        public Void visitAlias(AliasSymbol aliasSymbol, Void context) {
            return aliasSymbol.symbol().accept(this, context);
        }
    }
}

