/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.Protocol;
import io.crate.types.DataTypes;
import io.netty.handler.ssl.ClientAuth;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class AuthSettings {
    public static final Setting<Boolean> AUTH_HOST_BASED_ENABLED_SETTING = Setting.boolSetting("auth.host_based.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Settings> AUTH_HOST_BASED_CONFIG_SETTING = Setting.groupSetting("auth.host_based.config.", Setting.Property.NodeScope);
    public static final Setting<String> AUTH_HOST_BASED_JWT_ISS_SETTING = Setting.simpleString("auth.host_based.jwt.iss", Setting.Property.NodeScope);
    public static final Setting<String> AUTH_HOST_BASED_JWT_AUD_SETTING = Setting.simpleString("auth.host_based.jwt.aud", Setting.Property.NodeScope);
    public static final Setting<String> AUTH_TRUST_HTTP_DEFAULT_HEADER = new Setting("auth.trust.http_default_user", "crate", Function.identity(), DataTypes.STRING, Setting.Property.NodeScope);
    public static final String HTTP_HEADER_REAL_IP = "X-Real-Ip";
    public static final Setting<Boolean> AUTH_TRUST_HTTP_SUPPORT_X_REAL_IP = Setting.boolSetting("auth.trust.http_support_x_real_ip", false, Setting.Property.NodeScope);

    private AuthSettings() {
    }

    public static ClientAuth resolveClientAuth(Settings settings, Protocol protocol) {
        Settings hbaSettings = AUTH_HOST_BASED_CONFIG_SETTING.get(settings);
        int numMethods = 0;
        int numCertMethods = 0;
        for (Map.Entry<String, Settings> entry : hbaSettings.getAsGroups().entrySet()) {
            Settings entrySettings = entry.getValue();
            String protocolEntry = entrySettings.get("protocol");
            if (protocolEntry != null && !protocol.name().equalsIgnoreCase(protocolEntry)) continue;
            String method = entrySettings.get("method", "trust");
            ++numMethods;
            if (!method.equals("cert")) continue;
            ++numCertMethods;
        }
        if (numCertMethods == 0) {
            return ClientAuth.NONE;
        }
        return numCertMethods == numMethods ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL;
    }
}

