/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthSettings;
import io.crate.auth.Authentication;
import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Credentials;
import io.crate.auth.Protocol;
import io.crate.protocols.SSL;
import io.crate.protocols.http.Headers;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Role;
import io.crate.role.Roles;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class HttpAuthUpstreamHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LogManager.getLogger(HttpAuthUpstreamHandler.class);
    @VisibleForTesting
    static final String WWW_AUTHENTICATE_REALM_MESSAGE = "Basic realm=\"CrateDB Authenticator\"";
    private static final List<String> REAL_IP_HEADER_BLACKLIST = List.of("127.0.0.1", "::1");
    private final Authentication authService;
    private final Settings settings;
    private final boolean checkJwtProperties;
    private final Roles roles;
    private String authorizedUser = null;

    public HttpAuthUpstreamHandler(Settings settings, Authentication authService, Roles roles) {
        super(false);
        this.settings = settings;
        this.checkJwtProperties = settings.get(AuthSettings.AUTH_HOST_BASED_JWT_ISS_SETTING.getKey()) == null;
        this.authService = authService;
        this.roles = roles;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.handleHttpRequest(ctx, httpRequest);
        } else if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.handleHttpChunk(ctx, httpContent);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest request) {
        String username;
        Role role;
        SSLSession session = SSL.getSession(ctx.channel());
        Credentials credentials = HttpAuthUpstreamHandler.credentialsFromRequest(request, session, this.settings);
        Predicate<Role> rolePredicate = credentials.matchByToken(this.checkJwtProperties);
        if (rolePredicate != null && (role = this.roles.findUser(rolePredicate)) != null) {
            credentials.setUsername(role.name());
        }
        if ((username = credentials.username()) != null && username.equals(this.authorizedUser)) {
            ctx.fireChannelRead((Object)request);
            return;
        }
        InetAddress address = this.addressFromRequestOrChannel(request, ctx.channel());
        ConnectionProperties connectionProperties = new ConnectionProperties(credentials, address, Protocol.HTTP, session);
        AuthenticationMethod authMethod = this.authService.resolveAuthenticationType(username, connectionProperties);
        if (authMethod == null) {
            String errorMessage = String.format(Locale.ENGLISH, "No valid auth.host_based.config entry found for host \"%s\", user \"%s\", protocol \"%s\". Did you enable TLS in your client?", new Object[]{address.getHostAddress(), username, Protocol.HTTP});
            HttpAuthUpstreamHandler.sendUnauthorized(ctx.channel(), errorMessage);
        } else {
            try {
                Role user = authMethod.authenticate(credentials, connectionProperties);
                if (user != null && LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Authentication succeeded user \"{}\" and method \"{}\".", (Object)username, (Object)authMethod.name());
                }
                this.authorizedUser = username;
                ctx.fireChannelRead((Object)request);
            }
            catch (Exception e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("{} authentication failed for user={} from connection={}", (Object)authMethod.name(), (Object)username, (Object)connectionProperties.address());
                }
                HttpAuthUpstreamHandler.sendUnauthorized(ctx.channel(), e.getMessage());
            }
            finally {
                credentials.close();
            }
        }
    }

    private void handleHttpChunk(ChannelHandlerContext ctx, HttpContent msg) {
        if (this.authorizedUser == null) {
            msg.release();
            HttpAuthUpstreamHandler.sendUnauthorized(ctx.channel(), null);
        } else {
            ctx.fireChannelRead((Object)msg);
        }
    }

    @VisibleForTesting
    static void sendUnauthorized(Channel channel, @Nullable String body) {
        DefaultFullHttpResponse response;
        if (body != null) {
            if (!((String)body).endsWith("\n")) {
                body = (String)body + "\n";
            }
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.copiedBuffer((CharSequence)body, (Charset)StandardCharsets.UTF_8));
            HttpUtil.setContentLength((HttpMessage)response, (long)((String)body).length());
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
        }
        response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)WWW_AUTHENTICATE_REALM_MESSAGE);
        channel.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @VisibleForTesting
    boolean authorized() {
        return this.authorizedUser != null;
    }

    @VisibleForTesting
    static Credentials credentialsFromRequest(HttpRequest request, @Nullable SSLSession session, Settings settings) {
        String username = null;
        if (request.headers().contains(HttpHeaderNames.AUTHORIZATION.toString())) {
            return Headers.extractCredentialsFromHttpAuthHeader(request.headers().get(HttpHeaderNames.AUTHORIZATION.toString()));
        }
        if (session != null) {
            try {
                Certificate certificate = session.getPeerCertificates()[0];
                username = SSL.extractCN(certificate);
            }
            catch (ArrayIndexOutOfBoundsException | SSLPeerUnverifiedException exception) {
                // empty catch block
            }
        }
        if (username == null) {
            username = AuthSettings.AUTH_TRUST_HTTP_DEFAULT_HEADER.get(settings);
        }
        return new Credentials(username, null);
    }

    private InetAddress addressFromRequestOrChannel(HttpRequest request, Channel channel) {
        boolean supportXRealIp = AuthSettings.AUTH_TRUST_HTTP_SUPPORT_X_REAL_IP.get(this.settings);
        String realIP = request.headers().get("X-Real-Ip");
        if (supportXRealIp && realIP != null && !REAL_IP_HEADER_BLACKLIST.contains(realIP)) {
            return InetAddresses.forString(realIP);
        }
        return Netty4HttpServerTransport.getRemoteAddress(channel);
    }
}

