/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.DeleteBlobRequest;
import io.crate.blob.PutChunkRequest;
import io.crate.blob.PutChunkResponse;
import io.crate.blob.StartBlobRequest;
import io.crate.blob.StartBlobResponse;
import io.crate.blob.TransportDeleteBlob;
import io.crate.blob.TransportPutChunk;
import io.crate.blob.TransportStartBlob;
import io.crate.common.Hex;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class RemoteDigestBlob {
    private static final Logger LOGGER = LogManager.getLogger(RemoteDigestBlob.class);
    private final ShardId shardId;
    private final String digest;
    private final Client client;
    private long size;
    private StartBlobResponse startResponse;
    private UUID transferId;
    private Status status;

    public RemoteDigestBlob(Client client, ShardId shardId, String digest) {
        this.digest = digest;
        this.client = client;
        this.size = 0L;
        this.shardId = shardId;
    }

    public Status status() {
        return this.status;
    }

    public boolean delete() {
        LOGGER.trace("delete");
        assert (this.transferId == null) : "transferId should be null";
        DeleteBlobRequest request = new DeleteBlobRequest(this.shardId, Hex.decodeHex((String)this.digest));
        return FutureUtils.get(this.client.execute(TransportDeleteBlob.ACTION, request)).deleted;
    }

    private Status start(ByteBuf buffer, boolean last) {
        LOGGER.trace("start blob upload");
        assert (this.transferId == null) : "transferId should be null";
        StartBlobRequest request = new StartBlobRequest(this.shardId, Hex.decodeHex((String)this.digest), Netty4Utils.toBytesReference(buffer), last);
        this.transferId = request.transferId();
        this.size += (long)buffer.readableBytes();
        this.startResponse = FutureUtils.get(this.client.execute(TransportStartBlob.ACTION, request));
        this.status = this.startResponse.status();
        return this.status;
    }

    private Status chunk(ByteBuf buffer, boolean last) {
        assert (this.transferId != null) : "transferId should not be null";
        PutChunkRequest request = new PutChunkRequest(this.shardId, Hex.decodeHex((String)this.digest), this.transferId, Netty4Utils.toBytesReference(buffer), this.size, last);
        this.size += (long)buffer.readableBytes();
        PutChunkResponse putChunkResponse = FutureUtils.get(this.client.execute(TransportPutChunk.ACTION, request));
        return putChunkResponse.status();
    }

    public Status addContent(ByteBuf buffer, boolean last) {
        if (this.startResponse == null) {
            return this.start(buffer, last);
        }
        if (this.status == Status.EXISTS) {
            return this.status;
        }
        if (this.status != Status.PARTIAL) {
            throw new IllegalStateException("Expected Status.PARTIAL for chunk but got: " + String.valueOf((Object)this.status));
        }
        return this.chunk(buffer, last);
    }

    public long size() {
        return this.size;
    }

    public static enum Status {
        FULL(0),
        PARTIAL(1),
        MISMATCH(2),
        EXISTS(3),
        FAILED(4);

        private final byte id;

        private Status(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Status fromId(byte id) {
            switch (id) {
                case 0: {
                    return FULL;
                }
                case 1: {
                    return PARTIAL;
                }
                case 2: {
                    return MISMATCH;
                }
                case 3: {
                    return EXISTS;
                }
                case 4: {
                    return FAILED;
                }
            }
            throw new IllegalArgumentException("No status match for [" + id + "]");
        }
    }
}

