/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.transfer;

import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public abstract class BlobTransportRequest
extends TransportRequest {
    public final UUID transferId;
    public final String senderNodeId;

    public BlobTransportRequest(String senderNodeId, UUID transferId) {
        this.senderNodeId = senderNodeId;
        this.transferId = transferId;
    }

    public BlobTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.senderNodeId = in.readString();
        this.transferId = new UUID(in.readLong(), in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.senderNodeId);
        out.writeLong(this.transferId.getMostSignificantBits());
        out.writeLong(this.transferId.getLeastSignificantBits());
    }
}

