/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.transfer;

import io.crate.blob.BlobTransferTarget;
import io.crate.blob.DigestBlob;
import io.crate.blob.transfer.HeadChunkFileTooSmallException;
import io.crate.blob.transfer.PutBlobHeadChunkRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.PlainFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PutHeadChunkRunnable
implements Runnable {
    private final DigestBlob digestBlob;
    private final long bytesToSend;
    private final DiscoveryNode recipientNode;
    private final TransportService transportService;
    private final BlobTransferTarget blobTransferTarget;
    private final UUID transferId;
    private WatchKey watchKey;
    private WatchService watcher;
    private static final Logger LOGGER = LogManager.getLogger(PutHeadChunkRunnable.class);

    public PutHeadChunkRunnable(DigestBlob digestBlob, long bytesToSend, TransportService transportService, BlobTransferTarget blobTransferTarget, DiscoveryNode recipientNode, UUID transferId) {
        this.digestBlob = digestBlob;
        this.bytesToSend = bytesToSend;
        this.recipientNode = recipientNode;
        this.blobTransferTarget = blobTransferTarget;
        this.transferId = transferId;
        this.transportService = transportService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FileInputStream fileInputStream = null;
        try {
            File pendingFile;
            int bufSize = 4096;
            int maxFileGrowthWait = 5;
            int fileGrowthWaited = 0;
            byte[] buffer = new byte[bufSize];
            long remainingBytes = this.bytesToSend;
            try {
                pendingFile = this.digestBlob.file();
                if (pendingFile == null) {
                    pendingFile = this.digestBlob.getContainerFile();
                }
                fileInputStream = new FileInputStream(pendingFile);
            }
            catch (FileNotFoundException e) {
                pendingFile = this.digestBlob.getContainerFile();
                fileInputStream = new FileInputStream(pendingFile);
            }
            while (remainingBytes > 0L) {
                int size = (int)Math.min((long)bufSize, remainingBytes);
                int bytesRead = fileInputStream.read(buffer, 0, size);
                if (bytesRead < size) {
                    this.waitUntilFileHasGrown(pendingFile);
                    if (++fileGrowthWaited == maxFileGrowthWait) {
                        throw new HeadChunkFileTooSmallException(pendingFile.getAbsolutePath());
                    }
                    if (bytesRead < 1) continue;
                }
                remainingBytes -= (long)bytesRead;
                PlainFuture listener = new PlainFuture();
                this.transportService.sendRequest(this.recipientNode, "internal:crate:blob/shard/tmp_transfer/put_head_chunk", (TransportRequest)new PutBlobHeadChunkRequest(this.transferId, new BytesArray(buffer, 0, bytesRead)), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>("internal:crate:blob/shard/tmp_transfer/put_head_chunk", listener, streamInput -> TransportResponse.Empty.INSTANCE));
                FutureUtils.get(listener);
            }
        }
        catch (IOException ex) {
            LOGGER.error("IOException in PutHeadChunkRunnable", (Throwable)ex);
        }
        finally {
            this.blobTransferTarget.putHeadChunkTransferFinished(this.transferId);
            if (this.watcher != null) {
                try {
                    this.watcher.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing WatchService in {}", (Object)e, (Object)this.getClass().getSimpleName());
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Error closing HeadChunk", (Throwable)e);
                }
            }
        }
    }

    private void waitUntilFileHasGrown(File pendingFile) {
        try {
            WatchEvent<?> ev;
            Path filename;
            WatchEvent<?> event;
            WatchEvent.Kind<?> kind;
            if (this.watcher == null) {
                this.initWatcher(pendingFile.getParent());
            }
            this.watchKey = this.watcher.poll(5L, TimeUnit.SECONDS);
            if (this.watchKey == null) {
                return;
            }
            Iterator<WatchEvent<?>> iterator = this.watchKey.pollEvents().iterator();
            while (iterator.hasNext() && ((kind = (event = iterator.next()).kind()) == StandardWatchEventKinds.OVERFLOW || !(filename = (Path)(ev = event).context()).toString().equals(pendingFile.getName()))) {
            }
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private void initWatcher(String directoryToWatch) throws IOException {
        FileSystem fs = FileSystems.getDefault();
        this.watcher = fs.newWatchService();
        Path path = fs.getPath(directoryToWatch, new String[0]);
        this.watchKey = path.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
    }
}

