/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob.v2;

import io.crate.blob.v2.BlobShard;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.Nullable;

public class BlobIndex {
    private static final String INDEX_PREFIX = ".blob_";
    private final Map<Integer, BlobShard> shards = new ConcurrentHashMap<Integer, BlobShard>();
    private final Path globalBlobPath;
    private final Logger logger;

    public static boolean isBlobIndex(String indexName) {
        return indexName.startsWith(INDEX_PREFIX);
    }

    public static String fullIndexName(String indexName) {
        if (BlobIndex.isBlobIndex(indexName)) {
            return indexName;
        }
        return INDEX_PREFIX + indexName;
    }

    public static String stripPrefix(String indexName) {
        if (!BlobIndex.isBlobIndex(indexName)) {
            return indexName;
        }
        return indexName.substring(INDEX_PREFIX.length());
    }

    BlobIndex(Logger logger, @Nullable Path globalBlobPath) {
        this.globalBlobPath = globalBlobPath;
        this.logger = logger;
    }

    void createShard(IndexShard indexShard) {
        this.shards.put(indexShard.shardId().id(), new BlobShard(indexShard, this.globalBlobPath));
    }

    void initializeShard(IndexShard indexShard) {
        BlobShard blobShard = this.shards.get(indexShard.shardId().id());
        if (blobShard == null) {
            throw new IllegalStateException("Shard needs to be created before it is initialized");
        }
        blobShard.initialize();
    }

    BlobShard removeShard(ShardId shardId) {
        Path blobRoot = null;
        BlobShard shard = this.shards.remove(shardId.id());
        if (shard != null) {
            if (this.shards.isEmpty()) {
                blobRoot = BlobIndex.retrieveBlobRootDir(shard.getBlobDir(), shard.indexShard().shardId().getIndexName(), this.logger);
            }
            shard.deleteShard();
            if (blobRoot != null) {
                this.deleteIndex(blobRoot, shardId.getIndex().getName());
            }
        }
        return shard;
    }

    static Path retrieveBlobRootDir(Path blobDir, String indexName, Logger logger) {
        while (!blobDir.endsWith(indexName)) {
            if ((blobDir = blobDir.getParent()) == null) {
                logger.debug("Blob index directory not found for index '{}'", (Object)indexName);
            }
            if (blobDir != null) continue;
        }
        return blobDir;
    }

    private void deleteIndex(Path blobRoot, String index) {
        if (Files.exists(blobRoot, new LinkOption[0])) {
            this.logger.debug("[{}] Deleting blob index directory '{}'", (Object)index, (Object)blobRoot);
            try {
                IOUtils.rm((Path[])new Path[]{blobRoot});
            }
            catch (IOException e) {
                this.logger.warn("Could not delete blob index directory {}", (Object)blobRoot);
            }
        } else {
            this.logger.warn("Wanted to delete blob index directory {} but it was already gone", (Object)blobRoot);
        }
    }

    BlobShard getShard(int shardId) {
        return this.shards.get(shardId);
    }

    void delete() {
        Iterator<Map.Entry<Integer, BlobShard>> it = this.shards.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BlobShard> e = it.next();
            it.remove();
            e.getValue().deleteShard();
        }
    }
}

