/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.data.Row;
import io.crate.types.DataType;
import java.util.List;
import java.util.function.IntFunction;

public abstract class CellsSizeEstimator {
    protected CellsSizeEstimator() {
    }

    public static CellsSizeEstimator forColumns(final List<? extends DataType<?>> columnTypes) {
        return new CellsSizeEstimator(){

            @Override
            protected long estimateSize(int valueCount, IntFunction<Object> values) {
                assert (columnTypes.size() == valueCount) : "Size of incoming cells must match number of estimators. Cells=" + valueCount + " estimators=" + columnTypes.size();
                long size = 0L;
                for (int i = 0; i < valueCount; ++i) {
                    DataType dataType = (DataType)columnTypes.get(i);
                    size += dataType.valueBytes(values.apply(i));
                }
                return size;
            }
        };
    }

    public static CellsSizeEstimator constant(final long value) {
        return new CellsSizeEstimator(){

            @Override
            protected long estimateSize(int valueCount, IntFunction<Object> values) {
                return value;
            }
        };
    }

    protected abstract long estimateSize(int var1, IntFunction<Object> var2);

    public final long estimateSize(Row row) {
        return this.estimateSize(row.numColumns(), arg_0 -> ((Row)row).get(arg_0));
    }

    public final long estimateSize(Object[] cells) {
        return this.estimateSize(cells.length, i -> cells[i]);
    }
}

