/*
 * Decompiled with CFR 0.152.
 */
package io.crate.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public final class CountDown {
    private final AtomicInteger countDown;

    public CountDown(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be greater or equal to 0 but was: " + count);
        }
        this.countDown = new AtomicInteger(count);
    }

    public boolean countDown() {
        return this.countDown.decrementAndGet() == 0;
    }

    public boolean fastForward() {
        assert (this.countDown.get() >= 0);
        return this.countDown.getAndSet(0) > 0;
    }

    public boolean isCountedDown() {
        assert (this.countDown.get() >= 0);
        return this.countDown.get() == 0;
    }
}

