/*
 * Decompiled with CFR 0.152.
 */
package io.crate.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public class CountdownFuture
extends CompletableFuture<Void>
implements BiConsumer<Object, Throwable> {
    private final AtomicInteger counter;
    private final AtomicReference<Throwable> lastFailure = new AtomicReference();

    public CountdownFuture(int numCalls) {
        this.counter = new AtomicInteger(numCalls);
    }

    public void onSuccess() {
        this.countdown();
    }

    public void onFailure(@NotNull Throwable t) {
        Throwable previousFailure = this.lastFailure.getAndSet(t);
        if (previousFailure != null) {
            t.addSuppressed(previousFailure);
        }
        this.countdown();
    }

    public void onFailure(UnaryOperator<Throwable> updateLastFailure) {
        this.lastFailure.updateAndGet(updateLastFailure);
        this.countdown();
    }

    private void countdown() {
        if (this.counter.decrementAndGet() == 0) {
            Throwable throwable = this.lastFailure.get();
            if (throwable == null) {
                this.complete(null);
            } else {
                this.completeExceptionally(throwable);
            }
        }
    }

    @Override
    public void accept(Object o, Throwable t) {
        if (t == null) {
            this.onSuccess();
        } else {
            this.onFailure(t);
        }
    }

    @Override
    public String toString() {
        return "CountdownFuture{counter=" + String.valueOf(this.counter) + ", lastFailure=" + String.valueOf(this.lastFailure) + "}";
    }
}

