/*
 * Decompiled with CFR 0.152.
 */
package io.crate.concurrent;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;

public final class MultiActionListener<I, S, R>
implements ActionListener<I> {
    private final AtomicInteger counter;
    private final AtomicReference<Exception> lastExceptions = new AtomicReference<Object>(null);
    private final BiConsumer<S, I> accumulator;
    private final Function<S, R> finisher;
    private final ActionListener<? super R> actionListener;
    private final S state;

    public static <I> ActionListener<I> of(int numResponses, ActionListener<Collection<I>> listener) {
        return new MultiActionListener(numResponses, Collectors.toList(), listener);
    }

    public MultiActionListener(int numResponses, Collector<I, S, R> collector, ActionListener<? super R> listener) {
        this(numResponses, collector.supplier(), collector.accumulator(), collector.finisher(), listener);
    }

    public MultiActionListener(int numResponses, Supplier<S> stateSupplier, BiConsumer<S, I> accumulator, Function<S, R> finisher, ActionListener<? super R> actionListener) {
        this.accumulator = accumulator;
        this.finisher = finisher;
        this.actionListener = actionListener;
        this.state = stateSupplier.get();
        this.counter = new AtomicInteger(numResponses);
        if (numResponses == 0) {
            actionListener.onResponse(finisher.apply(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(I response) {
        S s = this.state;
        synchronized (s) {
            try {
                this.accumulator.accept(this.state, response);
            }
            catch (Exception e) {
                this.lastExceptions.set(e);
            }
        }
        this.countdown();
    }

    @Override
    public void onFailure(Exception e) {
        this.lastExceptions.set(e);
        this.countdown();
    }

    private void countdown() {
        if (this.counter.decrementAndGet() == 0) {
            Exception e = this.lastExceptions.get();
            if (e == null) {
                this.actionListener.onResponse(this.finisher.apply(this.state));
            } else {
                this.actionListener.onFailure(e);
            }
        }
    }
}

