/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.CrateExceptionVisitor;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.sql.SqlFormatter;
import java.util.Collections;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ColumnUnknownException
extends RuntimeException
implements ResourceUnknownException,
TableScopeException {
    private final RelationName relationName;
    private final RelationType relationType;

    public ColumnUnknownException(ColumnIdent columnIdent, RelationName relationName) {
        this(String.format(Locale.ENGLISH, "Column %s unknown", columnIdent.sqlFqn()), relationName, RelationType.TABLE);
    }

    private ColumnUnknownException(String message, RelationName relationName, RelationType relationType) {
        super(message);
        this.relationName = relationName;
        this.relationType = relationType;
    }

    public static ColumnUnknownException ofUnknownRelation(String message) {
        return new ColumnUnknownException(message, null, RelationType.UNKNOWN);
    }

    public static ColumnUnknownException ofTableFunctionRelation(String message, RelationName relationName) {
        return new ColumnUnknownException(message, relationName, RelationType.TABLE_FUNCTION);
    }

    public static ColumnUnknownException forSubscript(Symbol symbol, String key) {
        return symbol.accept(UnknownSubColumnError.INSTANCE, key);
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return this.relationName == null ? Collections.emptyList() : Collections.singletonList(this.relationName);
    }

    @Override
    public <C, R> R accept(CrateExceptionVisitor<C, R> exceptionVisitor, C context) {
        return exceptionVisitor.visitColumnUnknownException(this, context);
    }

    @NotNull
    public RelationType relationType() {
        return this.relationType;
    }

    public static enum RelationType {
        TABLE,
        TABLE_FUNCTION,
        UNKNOWN;

    }

    public static class UnknownSubColumnError
    extends SymbolVisitor<String, ColumnUnknownException> {
        public static final UnknownSubColumnError INSTANCE = new UnknownSubColumnError();
        private static final String CAST_HINT = "Consider to include inner type definition in the `OBJECT` type while casting, disable DYNAMIC unknown key errors by the `error_on_unknown_object_key` setting or cast to `OBJECT(IGNORED)`.";

        @Override
        protected ColumnUnknownException visitSymbol(Symbol symbol, String key) {
            return ColumnUnknownException.ofUnknownRelation(String.format(Locale.ENGLISH, "The return type `%s` of the expression `%s` does not contain the key `%s`", SqlFormatter.formatSqlInline(symbol.valueType().toColumnType(null)), ColumnIdent.of(symbol.toString(Style.QUALIFIED)), key));
        }

        @Override
        public ColumnUnknownException visitFunction(Function symbol, String key) {
            if (symbol.name().equals("cast")) {
                return ColumnUnknownException.ofUnknownRelation(String.format(Locale.ENGLISH, "The cast of `%s` to return type `%s` does not contain the key `%s`.\n%s", ColumnIdent.of(symbol.arguments().getFirst().toString(Style.QUALIFIED)), SqlFormatter.formatSqlInline(symbol.valueType().toColumnType(null)), key, CAST_HINT));
            }
            return this.visitSymbol((Symbol)symbol, key);
        }

        @Override
        public ColumnUnknownException visitLiteral(Literal<?> symbol, String key) {
            return ColumnUnknownException.ofUnknownRelation(String.format(Locale.ENGLISH, "The literal `%s` does not contain the key `%s`", symbol.value(), key));
        }
    }
}

